/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.bitstate;

import announce4j.Announcer;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import obp2.core.IConfiguration;
import obp2.core.IFiredTransition;
import obp2.core.IStateSpaceManager;
import obp2.core.execution.IExecutionController;
import obp2.core.execution.IExecutionMonitor;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ITransitionRelation;

public class RandomExecutions<C extends IConfiguration, A>
implements IExecutionController<C, A> {
    protected final Announcer announcer = new Announcer(true);
    protected final IExecutionMonitor.Simple monitor = new IExecutionMonitor.Simple();
    protected final ILanguageModule<C, A, Object> languageModule;
    protected final Random random = new Random();
    protected final Set<C> known = new HashSet<C>();
    private final Set<C> targetSet = new HashSet<C>();
    protected static String configurationCountKey = "confs";
    protected BigInteger configurationCount = BigInteger.ZERO;
    protected static String transitionCountKey = "trans";
    protected BigInteger transitionCount = BigInteger.ZERO;
    protected static String executionCountKey = "execs";
    protected BigInteger executionCount = BigInteger.ZERO;
    protected Map<Integer, Integer> depthDeadlockMap = new LinkedHashMap<Integer, Integer>();
    protected Map<String, BigInteger> metrics = new LinkedHashMap<String, BigInteger>();

    public RandomExecutions(ILanguageModule<C, A, Object> languageModule) {
        this.languageModule = languageModule;
    }

    public RandomExecutions(ITransitionRelation<C, A, Object> transitionRelation, IStateSpaceManager<C, A, Object> stateSpaceManager) {
        this(transitionRelation.getModule());
    }

    public Announcer getAnnouncer() {
        return this.announcer;
    }

    public IStateSpaceManager<C, A, Object> getStateSpaceManager() {
        return null;
    }

    public ITransitionRelation<C, A, Object> getRuntime() {
        return this.languageModule.getTransitionRelation();
    }

    public IExecutionMonitor getMonitor() {
        return this.monitor;
    }

    protected <T> T pickRandomly(Collection<T> collection) {
        int randomIndex = this.random.nextInt(collection.size());
        Iterator<T> configurationIterator = collection.iterator();
        for (int currentIndex = 0; currentIndex < randomIndex; ++currentIndex) {
            configurationIterator.next();
        }
        return configurationIterator.next();
    }

    protected C randomInitial() {
        Set intialConfigurationSet = this.getRuntime().initialConfigurations();
        if (intialConfigurationSet.isEmpty()) {
            return null;
        }
        return (C)((IConfiguration)this.pickRandomly(intialConfigurationSet));
    }

    protected synchronized C randomTarget(C source, boolean deep) {
        Set actions = this.getRuntime().fireableTransitionsFrom(source);
        if (!deep && !actions.isEmpty()) {
            actions = Collections.singleton(this.pickRandomly(actions));
        }
        for (Object action : actions) {
            IFiredTransition firedTransition = this.getRuntime().fireOneTransition(source, action);
            this.transitionCount = this.transitionCount.add(BigInteger.ONE);
            this.targetSet.addAll(firedTransition.getTargets());
        }
        if (this.targetSet.isEmpty()) {
            return null;
        }
        IConfiguration randomTarget = (IConfiguration)this.pickRandomly(this.targetSet);
        this.targetSet.clear();
        return (C)randomTarget;
    }

    public void execute() {
        C initial = this.randomInitial();
        int depth = 0;
        while (initial != null) {
            this.configurationCount = this.configurationCount.add(BigInteger.ONE);
            this.known.add(initial);
            ++depth;
            C source = initial;
            C target = this.randomTarget(source, false);
            while (target != null) {
                this.configurationCount = this.configurationCount.add(BigInteger.ONE);
                this.known.add(target);
                source = target;
                target = this.randomTarget(source, false);
                ++depth;
            }
            if (depth == 2847) {
                System.out.println(source);
            }
            this.executionCount = this.executionCount.add(BigInteger.ONE);
            int depthDeadlockCount = this.depthDeadlockMap.computeIfAbsent(depth, d -> 0) + 1;
            this.depthDeadlockMap.put(depth, depthDeadlockCount);
            initial = this.randomInitial();
            depth = 0;
        }
    }

    public BigInteger configurationCount() {
        this.updateMetrics();
        return this.metrics.get(configurationCountKey);
    }

    public BigInteger stepCount() {
        return BigInteger.ZERO;
    }

    protected void updateMetrics() {
        this.metrics.clear();
        this.metrics.put(configurationCountKey, this.configurationCount);
        this.metrics.put("unique", BigInteger.valueOf(this.known.size()));
        this.metrics.put(transitionCountKey, this.transitionCount);
        this.metrics.put(executionCountKey, this.executionCount);
        if (this.depthDeadlockMap.keySet().size() < 3) {
            for (Map.Entry<Integer, Integer> depthDeadlockCount : this.depthDeadlockMap.entrySet()) {
                this.metrics.put("dl@depth " + depthDeadlockCount.getKey(), BigInteger.valueOf(depthDeadlockCount.getValue().intValue()));
            }
        } else {
            Iterator<Map.Entry<Integer, Integer>> iterator = this.depthDeadlockMap.entrySet().iterator();
            Map.Entry<Integer, Integer> current = iterator.next();
            int minDepth = current.getKey();
            int minCount = current.getValue();
            int maxDepth = current.getKey();
            int maxCount = current.getValue();
            while (iterator.hasNext()) {
                current = iterator.next();
                int depth = current.getKey();
                if (depth < minDepth) {
                    minDepth = depth;
                    minCount = current.getValue();
                    continue;
                }
                if (depth <= maxDepth) continue;
                maxDepth = depth;
                maxCount = current.getValue();
            }
            this.metrics.put("dl@depth " + minDepth + " (min)", BigInteger.valueOf(minCount));
            this.metrics.put("dl@depth " + maxDepth + " (max)", BigInteger.valueOf(maxCount));
        }
    }

    public Map<String, BigInteger> metrics() {
        this.updateMetrics();
        return this.metrics;
    }
}

