/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.cdl.diagram;

import obp.cdl.Activity;
import obp.cdl.ParActivity;
import obp.ui.cdl.diagram.ActivityElement;
import obp.ui.cdl.diagram.CDLDiagram;
import org.xid.basics.geometry.Geometry;
import org.xid.basics.ui.diagram.DiagramContext;
import org.xid.basics.ui.diagram.gc.GC;
import org.xid.basics.ui.diagram.gc.GcUtils;

public class ParActivityElement
extends ActivityElement {
    private final ParActivity model;

    public ParActivityElement(ParActivity model, boolean rejoin, float[] northPoint) {
        super(rejoin, northPoint);
        this.model = model;
    }

    @Override
    public void buildChildren(CDLDiagram diagram) {
        float[] refPoint = Geometry.copyPoints((float[])this.northPoint);
        refPoint[1] = refPoint[1] + 50.0f;
        for (int i = 0; i < this.model.getActivityCount(); ++i) {
            boolean last;
            Activity child = this.model.getActivity(i);
            ActivityElement element = ParActivityElement.createElement(diagram, child, (last = i == this.model.getActivityCount() - 1) || this.rejoin, refPoint);
            if (element == null) continue;
            this.children.add(element);
            this.size[0] = this.size[0] + element.getSize()[0];
            this.size[1] = Math.max(this.size[1], element.getSize()[1]);
            refPoint[0] = refPoint[0] + (element.getSize()[0] + 50.0f);
        }
        if (this.children.size() > 1) {
            this.size[0] = this.size[0] + (float)(this.children.size() - 1) * 50.0f;
        }
        this.size[1] = this.size[1] + 100.0f;
        float dx = -this.size[0] / 2.0f;
        float dy = this.size[1] / 2.0f;
        for (ActivityElement child : this.children) {
            child.moveNorthPoint(dx + child.size[0] / 2.0f, dy - child.size[1] / 2.0f - 50.0f);
        }
    }

    @Override
    public void moveNorthPoint(float dx, float dy) {
        super.moveNorthPoint(dx, dy);
        for (ActivityElement child : this.children) {
            child.moveNorthPoint(dx, dy);
        }
    }

    @Override
    public void display(GC gc, DiagramContext context) {
        gc.setBackground(context.getResources().getSystemColor(2));
        float[] tmp = Geometry.rectangleAlignedOn((float)30.0f, (float)5.0f, (float)this.northPoint[0], (float)this.northPoint[1], (int)-1);
        GcUtils.drawRectangle((GC)gc, (float[])tmp, (boolean)true);
        tmp = Geometry.rectangleAlignedOn((float)30.0f, (float)5.0f, (float)this.northPoint[0], (float)(this.northPoint[1] + this.size[1]), (int)-1);
        GcUtils.drawRectangle((GC)gc, (float[])tmp, (boolean)true);
        gc.setBackground(context.getDiagram().getBackground(context));
        for (ActivityElement child : this.children) {
            tmp = new float[]{this.northPoint[0], this.northPoint[1], this.northPoint[0], this.northPoint[1] + 25.0f, child.northPoint[0], this.northPoint[1] + 25.0f, child.northPoint[0], child.northPoint[1]};
            GcUtils.drawPolyline((GC)gc, (float[])tmp, (boolean)false);
            float[] southPoint = this.getSouthPoint();
            tmp = new float[]{child.getSouthPoint()[0], child.getSouthPoint()[1], child.getSouthPoint()[0], southPoint[1] - 25.0f, southPoint[0], southPoint[1] - 25.0f, southPoint[0], southPoint[1]};
            GcUtils.drawPolyline((GC)gc, (float[])tmp, (boolean)false);
            context.getDiagram().resetGc(gc, context);
            child.display(gc, context);
            context.getDiagram().resetGc(gc, context);
        }
        super.display(gc, context);
    }

    @Override
    public ParActivity getModel() {
        return this.model;
    }
}

