/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import obp.explorer.runtime.simulation.InteractiveSimulator;
import obp.simulation.component.ConfigurationViewer;
import obp.simulation.component.ObserverDialog;
import obp.simulation.component.TextualConfigurationViewer;
import obp.simulation.component.TreeConfigurationViewer;
import obp.simulation.model.ConfigurationModel;
import obp.simulation.observer.ConfigurationObservable;
import obp.simulation.observer.ConfigurationObserver;

public class ConfigurationPanel
extends JPanel
implements ConfigurationObserver {
    private static final long serialVersionUID = 4937585403101052059L;
    private JTextField idConfigTextField;
    private JLabel info;
    private ConfigurationViewer textConfiguration;
    private ConfigurationViewer treeConfiguration;
    private JToolBar configurationTool = new JToolBar();
    private InteractiveSimulator simulator;

    public ConfigurationPanel(InteractiveSimulator simulator) {
        this.simulator = simulator;
        this.setBorder(BorderFactory.createTitledBorder("< Configurations >"));
        this.setLayout(new BorderLayout());
        this.build();
    }

    public void build() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout(0));
        JLabel lconfig = new JLabel("configuration : ");
        this.info = new JLabel();
        this.idConfigTextField = new JTextField();
        this.idConfigTextField.setPreferredSize(new Dimension(80, 24));
        this.configurationTool.add(lconfig);
        this.configurationTool.add(this.idConfigTextField);
        this.configurationTool.addSeparator();
        this.configurationTool.add(this.info);
        topPanel.add(this.configurationTool);
        this.add((Component)topPanel, "North");
        this.textConfiguration = new TextualConfigurationViewer(this.simulator);
        this.treeConfiguration = new TreeConfigurationViewer(this.simulator);
        JTabbedPane tabbedView = new JTabbedPane(3);
        tabbedView.addTab("Text View", this.textConfiguration.buildComponent());
        tabbedView.addTab("Tree View", this.treeConfiguration.buildComponent());
        this.add(tabbedView);
    }

    public JTextField getIdConfigTextField() {
        return this.idConfigTextField;
    }

    private void setIdConfigTextField(String id) {
        SwingUtilities.invokeLater(new DoSetText(id, this.idConfigTextField));
    }

    public void setInfo(String info) {
        this.info.setText(info);
    }

    @Override
    public void changeConfig(ConfigurationObservable confModel) {
        ConfigurationModel config = (ConfigurationModel)confModel;
        this.setIdConfigTextField(Integer.toString(config.getCurrentConfigId()));
        this.textConfiguration.updateComponent(config.getCurrentConfig());
        this.treeConfiguration.updateComponent(config.getCurrentConfig());
    }

    public void setObserverList(List<ObserverDialog> obsViewerList) {
        this.treeConfiguration.setObserverList(obsViewerList);
    }

    private static class DoSetText
    extends Thread {
        String text;
        JTextField idConfigTextField;

        public DoSetText(String text, JTextField idConfigTextField) {
            this.text = text;
            this.idConfigTextField = idConfigTextField;
        }

        @Override
        public void run() {
            boolean hasFocus = this.idConfigTextField.hasFocus();
            this.idConfigTextField.setFocusable(false);
            this.idConfigTextField.setText(this.text);
            this.idConfigTextField.setFocusable(true);
            if (hasFocus) {
                this.idConfigTextField.requestFocus();
            }
        }
    }
}

