/*
 * Decompiled with CFR 0.152.
 */
package DVE.fiacre;

import DVE.evaluation.StaticEvaluator;
import DVE.model.ArrayLiteral;
import DVE.model.Assignment;
import DVE.model.BinaryExpression;
import DVE.model.ChannelDeclaration;
import DVE.model.ConstantDeclaration;
import DVE.model.Expression;
import DVE.model.IndexedExpression;
import DVE.model.InputSynchronization;
import DVE.model.NamedDeclaration;
import DVE.model.NumberLiteral;
import DVE.model.OutputSynchronization;
import DVE.model.Process;
import DVE.model.System;
import DVE.model.Transition;
import DVE.model.TypedChannelDeclaration;
import DVE.model.UnaryExpression;
import DVE.model.VariableDeclaration;
import DVE.model.VariableReference;
import DVE.model.util.ModelSwitch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DVEGlobalUsageExtractor {
    Map<Process, Set<VariableDeclaration>> usedVariableMap = new HashMap<Process, Set<VariableDeclaration>>();
    Map<Process, Set<VariableDeclaration>> modifiedVariableMap = new HashMap<Process, Set<VariableDeclaration>>();
    Map<Process, Set<ChannelDeclaration>> inputChannelMap = new HashMap<Process, Set<ChannelDeclaration>>();
    Map<Process, Set<ChannelDeclaration>> outputChannelMap = new HashMap<Process, Set<ChannelDeclaration>>();
    Map<Process, Set<ChannelDeclaration>> inputQueueMap = new HashMap<Process, Set<ChannelDeclaration>>();
    Map<Process, Set<ChannelDeclaration>> outputQueueMap = new HashMap<Process, Set<ChannelDeclaration>>();
    Stack<Boolean> isRValueStack = new Stack();
    Process currentProcess = null;
    ModelSwitch<Boolean> modelSwitch = new ModelSwitch<Boolean>(){

        @Override
        public Boolean caseSystem(System object) {
            for (Process p : object.getProcesses()) {
                this.doSwitch(p);
            }
            return true;
        }

        @Override
        public Boolean caseProcess(Process object) {
            DVEGlobalUsageExtractor.this.currentProcess = object;
            DVEGlobalUsageExtractor.this.usedVariableMap.put(DVEGlobalUsageExtractor.this.currentProcess, new HashSet());
            DVEGlobalUsageExtractor.this.modifiedVariableMap.put(DVEGlobalUsageExtractor.this.currentProcess, new HashSet());
            DVEGlobalUsageExtractor.this.inputChannelMap.put(DVEGlobalUsageExtractor.this.currentProcess, new HashSet());
            DVEGlobalUsageExtractor.this.outputChannelMap.put(DVEGlobalUsageExtractor.this.currentProcess, new HashSet());
            DVEGlobalUsageExtractor.this.inputQueueMap.put(DVEGlobalUsageExtractor.this.currentProcess, new HashSet());
            DVEGlobalUsageExtractor.this.outputQueueMap.put(DVEGlobalUsageExtractor.this.currentProcess, new HashSet());
            for (NamedDeclaration nD : object.getDeclarations()) {
                this.doSwitch(nD);
            }
            for (Transition t : object.getTransitions()) {
                this.doSwitch(t);
            }
            return true;
        }

        @Override
        public Boolean caseVariableDeclaration(VariableDeclaration object) {
            if (object.getInitial() != null) {
                DVEGlobalUsageExtractor.this.isRValueStack.push(true);
                this.doSwitch(object.getInitial());
                DVEGlobalUsageExtractor.this.isRValueStack.pop();
            }
            return true;
        }

        @Override
        public Boolean caseTransition(Transition object) {
            if (object.getGuard() != null) {
                DVEGlobalUsageExtractor.this.isRValueStack.push(true);
                this.doSwitch(object.getGuard());
                DVEGlobalUsageExtractor.this.isRValueStack.pop();
            }
            if (object.getSync() != null) {
                this.doSwitch(object.getSync());
            }
            for (Assignment assign : object.getEffect()) {
                this.doSwitch(assign);
            }
            return true;
        }

        @Override
        public Boolean caseInputSynchronization(InputSynchronization object) {
            ChannelDeclaration chanD = object.getChannel().getRef();
            if (chanD instanceof TypedChannelDeclaration) {
                TypedChannelDeclaration chan = (TypedChannelDeclaration)chanD;
                int bufferSize = 0;
                if (chan.getBufferSize() != null) {
                    bufferSize = ((NumberLiteral)StaticEvaluator.evaluate(chan.getBufferSize())).getValue().intValue();
                }
                if (bufferSize > 0) {
                    DVEGlobalUsageExtractor.this.inputQueueMap.get(DVEGlobalUsageExtractor.this.currentProcess).add(chanD);
                } else {
                    DVEGlobalUsageExtractor.this.inputChannelMap.get(DVEGlobalUsageExtractor.this.currentProcess).add(chanD);
                }
            } else {
                DVEGlobalUsageExtractor.this.inputChannelMap.get(DVEGlobalUsageExtractor.this.currentProcess).add(chanD);
            }
            if (object.getValue() != null) {
                DVEGlobalUsageExtractor.this.isRValueStack.push(false);
                this.doSwitch(object.getValue());
                DVEGlobalUsageExtractor.this.isRValueStack.pop();
            }
            return true;
        }

        @Override
        public Boolean caseOutputSynchronization(OutputSynchronization object) {
            ChannelDeclaration chanD = object.getChannel().getRef();
            if (chanD instanceof TypedChannelDeclaration) {
                TypedChannelDeclaration chan = (TypedChannelDeclaration)chanD;
                int bufferSize = 0;
                if (chan.getBufferSize() != null) {
                    bufferSize = ((NumberLiteral)StaticEvaluator.evaluate(chan.getBufferSize())).getValue().intValue();
                }
                if (bufferSize > 0) {
                    DVEGlobalUsageExtractor.this.outputQueueMap.get(DVEGlobalUsageExtractor.this.currentProcess).add(chanD);
                } else {
                    DVEGlobalUsageExtractor.this.outputChannelMap.get(DVEGlobalUsageExtractor.this.currentProcess).add(chanD);
                }
            } else {
                DVEGlobalUsageExtractor.this.outputChannelMap.get(DVEGlobalUsageExtractor.this.currentProcess).add(chanD);
            }
            if (object.getValue() != null) {
                DVEGlobalUsageExtractor.this.isRValueStack.push(true);
                this.doSwitch(object.getValue());
                DVEGlobalUsageExtractor.this.isRValueStack.pop();
            }
            return true;
        }

        @Override
        public Boolean caseVariableReference(VariableReference object) {
            if (object.getRef() instanceof ConstantDeclaration) {
                return true;
            }
            for (NamedDeclaration vD : DVEGlobalUsageExtractor.this.currentProcess.getDeclarations()) {
                if (!EcoreUtil.equals((EObject)object.getRef(), (EObject)vD)) continue;
                return true;
            }
            if (DVEGlobalUsageExtractor.this.isRValueStack.peek().booleanValue()) {
                DVEGlobalUsageExtractor.this.usedVariableMap.get(DVEGlobalUsageExtractor.this.currentProcess).add(object.getRef());
            } else {
                DVEGlobalUsageExtractor.this.modifiedVariableMap.get(DVEGlobalUsageExtractor.this.currentProcess).add(object.getRef());
            }
            return true;
        }

        @Override
        public Boolean caseBinaryExpression(BinaryExpression object) {
            this.doSwitch((EObject)object.getOperands().get(0));
            this.doSwitch((EObject)object.getOperands().get(1));
            return true;
        }

        @Override
        public Boolean caseUnaryExpression(UnaryExpression object) {
            this.doSwitch(object.getOperand());
            return true;
        }

        @Override
        public Boolean caseArrayLiteral(ArrayLiteral object) {
            for (Expression e : object.getValues()) {
                this.doSwitch(e);
            }
            return true;
        }

        @Override
        public Boolean caseAssignment(Assignment object) {
            DVEGlobalUsageExtractor.this.isRValueStack.push(false);
            this.doSwitch(object.getLhs());
            DVEGlobalUsageExtractor.this.isRValueStack.pop();
            DVEGlobalUsageExtractor.this.isRValueStack.push(true);
            this.doSwitch(object.getRhs());
            DVEGlobalUsageExtractor.this.isRValueStack.pop();
            return true;
        }

        @Override
        public Boolean caseIndexedExpression(IndexedExpression object) {
            this.doSwitch(object.getBase());
            DVEGlobalUsageExtractor.this.isRValueStack.push(true);
            this.doSwitch(object.getIndex());
            DVEGlobalUsageExtractor.this.isRValueStack.pop();
            return true;
        }
    };

    public void extract(System sys) {
        this.modelSwitch.doSwitch(sys);
    }
}

