/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.bitstate;

import java.util.Arrays;
import java.util.Random;
import java.util.function.BiFunction;
import obp2.hash.SpookyHashV2;

public class BloomFilterN {
    int capacity = 0x100000;
    boolean[] store = new boolean[this.capacity];
    int size = 0;
    Random rnd = new Random();
    int[] seeds = new int[]{this.rnd.nextInt(), this.rnd.nextInt(), this.rnd.nextInt(), this.rnd.nextInt()};
    boolean doReset;
    double occupancyFactor;
    BiFunction<byte[], int[], Boolean> hashLambda;

    public BloomFilterN() {
        this.doReset = true;
        this.occupancyFactor = 0.3;
        try {
            SpookyHashV2.hash128((byte[])new byte[4], (int[])new int[4]);
            this.hashLambda = SpookyHashV2::hash128;
        }
        catch (UnsatisfiedLinkError e) {
            this.hashLambda = BloomFilterN::slowHash128;
        }
    }

    public BloomFilterN(int occupancyFactor, boolean doReset) {
        this.doReset = doReset;
        this.occupancyFactor = occupancyFactor;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public static boolean slowHash128(byte[] bytes, int[] hash) {
        int hashInt = Arrays.hashCode(bytes);
        hash[0] = hashInt ^ hash[0];
        hash[1] = hashInt ^ hash[1];
        hash[2] = hashInt ^ hash[2];
        hash[3] = hashInt ^ hash[3];
        return true;
    }

    public boolean contains(byte[] bytes) {
        int[] hash = (int[])this.seeds.clone();
        this.hashLambda.apply(bytes, hash);
        int[] slots = new int[4];
        for (int i = 0; i < 4; ++i) {
            slots[i] = (hash[i] > 0 ? hash[i] : -hash[i]) % this.capacity;
        }
        return this.store[slots[0]] && this.store[slots[1]] && this.store[slots[2]] && this.store[slots[3]];
    }

    public boolean add(byte[] bytes) {
        int i;
        int[] hash = (int[])this.seeds.clone();
        this.hashLambda.apply(bytes, hash);
        int nb_slots = 3;
        int[] slots = new int[nb_slots];
        for (i = 0; i < nb_slots; ++i) {
            slots[i] = Math.abs(hash[i]) % this.capacity;
        }
        if (this.store[slots[0]] && this.store[slots[1]] && this.store[slots[2]]) {
            return false;
        }
        if (this.doReset && (double)this.size > (double)this.capacity * this.occupancyFactor) {
            this.clear();
            return true;
        }
        for (i = 0; i < nb_slots; ++i) {
            this.store[slots[i]] = true;
        }
        ++this.size;
        return true;
    }

    public void clear() {
        Arrays.fill(this.store, false);
        this.size = 0;
        this.seeds = new int[]{this.rnd.nextInt(), this.rnd.nextInt(), this.rnd.nextInt(), this.rnd.nextInt()};
    }
}

