/*
 * Decompiled with CFR 0.152.
 */
package plug.bpmn2.semantics.transition.utils;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.emf.ecore.EObject;
import plug.bpmn2.model.BPMNModelHandler;
import plug.bpmn2.semantics.state.BPMNRuntimeInstance;
import plug.bpmn2.semantics.state.BPMNRuntimeState;
import plug.bpmn2.semantics.state.instance.FlowElementsContainerInstance;
import plug.bpmn2.semantics.state.instance.data.Token;
import plug.bpmn2.semantics.transition.Transition;
import plug.bpmn2.semantics.transition.kinds.TransitionCatchEvent;
import plug.bpmn2.semantics.transition.kinds.TransitionClose;
import plug.bpmn2.semantics.transition.kinds.TransitionEndEvent;
import plug.bpmn2.semantics.transition.kinds.TransitionGateway;
import plug.bpmn2.semantics.transition.kinds.TransitionOpen;

public class TransitionsFireable {
    public static void addFlowNodeTransitions(BPMNModelHandler model, BPMNRuntimeState state, FlowElementsContainerInstance flowInstance, FlowNode flowNode, Set<Transition> targetCollection) {
        Gateway gateway;
        TransitionGateway transition;
        if (flowNode instanceof EndEvent) {
            EndEvent endEvent = (EndEvent)flowNode;
            targetCollection.add(new TransitionEndEvent(model, state, flowInstance, endEvent));
        } else if (flowNode instanceof IntermediateCatchEvent) {
            IntermediateCatchEvent catchEvent = (IntermediateCatchEvent)flowNode;
            TransitionCatchEvent transition2 = new TransitionCatchEvent(model, state, flowInstance, catchEvent);
            if (transition2.guard(state)) {
                targetCollection.add(transition2);
            }
        } else if (flowNode instanceof Gateway && (transition = new TransitionGateway(model, state, flowInstance, gateway = (Gateway)flowNode)).guard(state)) {
            targetCollection.add(transition);
        }
    }

    public static void addFlowElementsContainerTransitions(BPMNModelHandler model, BPMNRuntimeState state, FlowElementsContainerInstance flowInstance, Set<Transition> targetCollection) {
        for (Token token : flowInstance.getTokenSet()) {
            FlowNode target = token.getBaseElement().getTargetRef();
            TransitionsFireable.addFlowNodeTransitions(model, state, flowInstance, target, targetCollection);
        }
        for (FlowElement flowElement : flowInstance.getBaseElement().getFlowElements()) {
            if (!(flowElement instanceof StartEvent)) continue;
            StartEvent startEvent = (StartEvent)flowElement;
            TransitionsFireable.addFlowNodeTransitions(model, state, flowInstance, (FlowNode)startEvent, targetCollection);
        }
    }

    public static void addOpenChildInstanceTransitions(BPMNModelHandler model, BPMNRuntimeState state, BPMNRuntimeInstance instance, Set<Transition> targetCollection) {
        for (EObject eObject : model.ownership.getTargetSet(instance.getBaseElement())) {
            BaseElement childElement;
            TransitionOpen open;
            if (!(eObject instanceof Activity) && !(eObject instanceof FlowElementsContainer) || !(open = new TransitionOpen(model, state, instance, childElement = (BaseElement)eObject)).guard(state)) continue;
            targetCollection.add(open);
        }
    }

    public static void addRelated(BPMNModelHandler model, BPMNRuntimeState state, BPMNRuntimeInstance instance, Set<Transition> targetCollection) {
        TransitionClose close = new TransitionClose(model, state, instance);
        if (close.guard(state)) {
            targetCollection.add(close);
        }
        if (instance instanceof FlowElementsContainerInstance) {
            FlowElementsContainerInstance flowInstance = (FlowElementsContainerInstance)instance;
            TransitionsFireable.addFlowElementsContainerTransitions(model, state, flowInstance, targetCollection);
        }
        TransitionsFireable.addOpenChildInstanceTransitions(model, state, instance, targetCollection);
        for (BPMNRuntimeInstance childInstance : instance.getChildInstanceList()) {
            TransitionsFireable.addRelated(model, state, childInstance, targetCollection);
        }
    }

    public static Set<Transition> get(BPMNModelHandler model, BPMNRuntimeState state) {
        HashSet<Transition> result = new HashSet<Transition>();
        for (BPMNRuntimeInstance instance : state.getRootInstanceList()) {
            TransitionsFireable.addRelated(model, state, instance, result);
        }
        return result;
    }
}

