/*
 * Decompiled with CFR 0.152.
 */
package plug.bpmn2.semantics.transition.utils;

import java.util.Collection;
import java.util.List;
import plug.bpmn2.model.BPMNModelHandler;
import plug.bpmn2.semantics.state.BPMNRuntimeInstance;
import plug.bpmn2.semantics.state.BPMNRuntimeState;
import plug.bpmn2.semantics.state.instance.ChoreographyInstance;
import plug.bpmn2.semantics.state.instance.CollaborationInstance;
import plug.bpmn2.semantics.state.instance.FlowElementsContainerInstance;
import plug.bpmn2.semantics.state.instance.ProcessInstance;
import plug.bpmn2.semantics.state.instance.SubProcessInstance;
import plug.bpmn2.semantics.state.instance.TaskInstance;
import plug.bpmn2.semantics.state.instance.data.Token;

public class ElementsClose {
    public static void removeInstance(BPMNRuntimeState state, BPMNRuntimeInstance instance) {
        BPMNRuntimeInstance parent = instance.getParent();
        List<BPMNRuntimeInstance> targetCollection = parent == null ? state.getRootInstanceList() : parent.getChildInstanceList();
        targetCollection.remove(instance);
    }

    public static boolean closeProcess(BPMNModelHandler model, BPMNRuntimeState state, ProcessInstance processInstance, boolean execute) {
        if (processInstance.getTokenSet().isEmpty() && processInstance.getChildInstanceList().isEmpty() && execute) {
            ElementsClose.removeInstance(state, processInstance);
        }
        return false;
    }

    public static boolean closeTask(BPMNModelHandler model, TaskInstance taskInstance, boolean execute) {
        FlowElementsContainerInstance parentInstance = taskInstance.getParent();
        if (!parentInstance.getChildInstanceList().contains(taskInstance)) {
            return false;
        }
        if (execute) {
            parentInstance.getChildInstanceList().remove(taskInstance);
            List outgoingSequenceFlows = taskInstance.getBaseElement().getOutgoing();
            Collection<Token> outgoingTokens = model.tokens.get(outgoingSequenceFlows);
            parentInstance.getTokenSet().addAll(outgoingTokens);
        }
        return true;
    }

    public static boolean close(BPMNModelHandler model, BPMNRuntimeState state, BPMNRuntimeInstance instance, boolean execute) {
        if (instance instanceof ChoreographyInstance) {
            return false;
        }
        if (instance instanceof CollaborationInstance) {
            return false;
        }
        if (instance instanceof SubProcessInstance) {
            throw new UnsupportedOperationException("Close SubProcessInstance");
        }
        if (instance instanceof ProcessInstance) {
            return ElementsClose.closeProcess(model, state, (ProcessInstance)instance, execute);
        }
        if (instance instanceof TaskInstance) {
            return ElementsClose.closeTask(model, (TaskInstance)instance, execute);
        }
        throw new UnsupportedOperationException("Close " + instance);
    }
}

