/*
 * Decompiled with CFR 0.152.
 */
package plug.bpmn2.semantics.transition;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import plug.bpmn2.semantics.state.BPMNRuntimeInstance;
import plug.bpmn2.semantics.state.BPMNRuntimeState;

public class RuntimeScope {
    private final LinkedList<Integer> path;
    private final String id;

    public RuntimeScope(BPMNRuntimeState state, BPMNRuntimeInstance instance) {
        int index;
        this.id = instance.getBaseElement().getId();
        this.path = new LinkedList();
        BPMNRuntimeInstance previousParent = instance;
        for (BPMNRuntimeInstance parent = instance.getParent(); parent != null; parent = parent.getParent()) {
            index = parent.getChildInstanceList().indexOf(previousParent);
            if (index == -1) {
                throw new IllegalStateException();
            }
            this.path.addFirst(index);
            previousParent = parent;
        }
        index = state.getRootInstanceList().indexOf(previousParent);
        if (index == -1) {
            throw new IllegalStateException();
        }
        this.path.addFirst(index);
    }

    public BPMNRuntimeInstance getInstance(BPMNRuntimeState state) {
        if (this.path.size() == 0) {
            return null;
        }
        List<BPMNRuntimeInstance> currentFloor = state.getRootInstanceList();
        int currentIndex = this.path.get(this.path.get(0));
        BPMNRuntimeInstance currentInstance = currentFloor.get(currentIndex);
        for (int i = 1; i < this.path.size(); ++i) {
            currentFloor = currentInstance.getChildInstanceList();
            currentIndex = this.path.get(i);
            currentInstance = currentFloor.get(currentIndex);
        }
        return currentInstance;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeScope that = (RuntimeScope)o;
        return this.path.equals(that.path) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.id);
    }
}

