/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;

public class RootProcesses {
    public static RootElement getRootElement(DocumentRoot documentRoot) {
        RootElement result = documentRoot.getRootElement();
        if (result == null) {
            if (documentRoot.getCollaboration() != null) {
                return documentRoot.getCollaboration();
            }
            ArrayList<Process> rootProcesses = new ArrayList<Process>();
            for (RootElement rootElement : documentRoot.getDefinitions().getRootElements()) {
                if (rootElement instanceof Collaboration) {
                    return rootElement;
                }
                if (!(rootElement instanceof Process)) continue;
                rootProcesses.add((Process)rootElement);
            }
            if (rootProcesses.size() == 1) {
                return (RootElement)rootProcesses.get(0);
            }
            throw new IllegalStateException("Document has null root element and no collaboration was found");
        }
        return result;
    }

    public static Set<Process> compute(DocumentRoot documentRoot) {
        HashSet<Process> result = new HashSet<Process>();
        RootElement rootElement = RootProcesses.getRootElement(documentRoot);
        if (rootElement instanceof Process) {
            result.add((Process)rootElement);
        } else if (rootElement instanceof Collaboration) {
            for (Participant participant : ((Collaboration)rootElement).getParticipants()) {
                result.add(participant.getProcessRef());
            }
        } else {
            throw new IllegalStateException("Unsupported root element: " + rootElement.getClass());
        }
        return result;
    }

    public static Set<Process> computeAllProcesses(DocumentRoot documentRoot) {
        Set<Process> processes = RootProcesses.compute(documentRoot);
        LinkedList<Process> unseenProcesses = new LinkedList<Process>(processes);
        while (!unseenProcesses.isEmpty()) {
            Process current = unseenProcesses.removeFirst();
            for (FlowElement flowElement : current.getFlowElements()) {
                Process calledProcess;
                CallActivity callActivity;
                if (!(flowElement instanceof CallActivity) || !((callActivity = (CallActivity)flowElement).getCalledElementRef() instanceof Process) || !processes.add(calledProcess = (Process)callActivity.getCalledElementRef())) continue;
                unseenProcesses.add(calledProcess);
            }
        }
        return processes;
    }
}

