/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.model;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import obp2.bpmn2.model.ProcessInstances;
import obp2.bpmn2.model.RootProcesses;
import obp2.bpmn2.model.action.FlowActionPool;
import obp2.bpmn2.model.action.FlowActionUtils;
import obp2.bpmn2.model.signal.SignalData;
import obp2.bpmn2.model.signal.SignalDataUtils;
import obp2.bpmn2.model.signal.SignalIdStrategy;
import obp2.bpmn2.model.token.TokenPool;
import obp2.bpmn2.model.token.TokenPoolUtils;
import obp2.bpmn2.utils.BPMN2ModelValidation;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.Process;

public class BPMN2ProcessedModel {
    private final DocumentRoot documentRoot;
    private final Set<Process> rootProcesses;
    private final TokenPool tokenPool;
    private final SignalData signalData;
    private final FlowActionPool flowActionPool;
    private final ProcessInstances processInstances;

    public BPMN2ProcessedModel(DocumentRoot documentRoot, Set<Process> rootProcesses, boolean includeCalledProcesses) {
        if (BPMN2ModelValidation.nodesAreMissingFlows(rootProcesses)) {
            BPMN2ModelValidation.addMissingFlows(rootProcesses);
        }
        this.documentRoot = documentRoot;
        this.rootProcesses = rootProcesses;
        this.tokenPool = TokenPoolUtils.compute(rootProcesses, includeCalledProcesses);
        this.signalData = SignalDataUtils.compute(rootProcesses, SignalIdStrategy::byName);
        this.flowActionPool = FlowActionUtils.compute(rootProcesses, this.tokenPool, this.signalData);
        this.processInstances = new ProcessInstances(this.tokenPool);
    }

    public BPMN2ProcessedModel(DocumentRoot documentRoot, Set<Process> rootProcesses) {
        this(documentRoot, rootProcesses, true);
    }

    public BPMN2ProcessedModel(DocumentRoot documentRoot, Process process) {
        this(documentRoot, Collections.singleton(process));
    }

    public BPMN2ProcessedModel(DocumentRoot documentRoot, Process process, boolean includeCalledProcesses) {
        this(documentRoot, Collections.singleton(process), includeCalledProcesses);
    }

    public BPMN2ProcessedModel(DocumentRoot documentRoot, boolean includeCalledProcesses) {
        this(documentRoot, RootProcesses.compute(documentRoot), includeCalledProcesses);
    }

    public BPMN2ProcessedModel(DocumentRoot documentRoot) {
        this(documentRoot, true);
    }

    public DocumentRoot getDocumentRoot() {
        return this.documentRoot;
    }

    public Set<Process> getRootProcesses() {
        return this.rootProcesses;
    }

    public TokenPool getTokenPool() {
        return this.tokenPool;
    }

    public SignalData getSignalData() {
        return this.signalData;
    }

    public FlowActionPool getFlowActionPool() {
        return this.flowActionPool;
    }

    public Process getProcess(List<CallActivity> callStack) {
        return this.processInstances.getProcess(callStack);
    }
}

