/*
 * Decompiled with CFR 0.152.
 */
package plug.bpmn2.semantics.state.walker;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Consumer;
import plug.bpmn2.semantics.state.BPMNInstanceVisitor;
import plug.bpmn2.semantics.state.BPMNRuntimeInstance;
import plug.bpmn2.semantics.state.walker.BPMNInstanceAspectHandler;
import plug.bpmn2.semantics.state.walker.SimpleInstanceAspectHandler;

public class BPMNRuntimeInstanceWalker {
    private final BPMNInstanceAspectHandler aspectHandler;
    private final BPMNInstanceVisitor leafVisitor;
    private final Set<BPMNRuntimeInstance> walkedInstanceSet;
    private final LinkedList<BPMNRuntimeInstance> toWalkInstanceList;

    public BPMNRuntimeInstanceWalker(BPMNInstanceAspectHandler aspectHandler, BPMNInstanceVisitor leafVisitor) {
        this.aspectHandler = aspectHandler;
        this.leafVisitor = leafVisitor;
        this.walkedInstanceSet = new HashSet<BPMNRuntimeInstance>();
        this.toWalkInstanceList = new LinkedList();
    }

    public BPMNRuntimeInstanceWalker(BPMNInstanceAspectHandler aspectHandler) {
        this(aspectHandler, new BPMNInstanceVisitor(){});
    }

    public BPMNRuntimeInstanceWalker(BPMNInstanceVisitor leafVisitor) {
        this(new BPMNInstanceAspectHandler(){}, leafVisitor);
    }

    public BPMNRuntimeInstanceWalker(Consumer<BPMNRuntimeInstance> doEach) {
        this(new SimpleInstanceAspectHandler(doEach));
    }

    public void walkInstanceTree(BPMNRuntimeInstance instance) {
        this.walkedInstanceSet.clear();
        this.toWalkInstanceList.clear();
        this.toWalkInstanceList.add(instance);
        while (!this.toWalkInstanceList.isEmpty()) {
            BPMNRuntimeInstance nextInstance = this.toWalkInstanceList.removeFirst();
            BPMNInstanceAspectHandler.handle(this.aspectHandler, nextInstance);
            nextInstance.acceptInstanceVisitor(this.leafVisitor);
            for (BPMNRuntimeInstance childInstance : nextInstance.getChildInstanceList()) {
                if (!this.walkedInstanceSet.add(childInstance)) continue;
                this.toWalkInstanceList.add(childInstance);
            }
        }
    }
}

