/*
 * Decompiled with CFR 0.152.
 */
package plug.bpmn2.model.analysis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDAGDiagnosis<T> {
    private Set<T> nodeSet = new HashSet<T>();
    private Map<T, Set<T>> sourceMap = new HashMap<T, Set<T>>();
    private Map<T, Set<T>> targetMap = new HashMap<T, Set<T>>();
    private final List<Set<T>> floorList = new LinkedList<Set<T>>();
    private final Map<Integer, Set<T>> depthNodeSetMap = new HashMap<Integer, Set<T>>();
    private final Map<T, Integer> nodeDepthMap = new HashMap<T, Integer>();

    public Set<T> getNodeSet() {
        return this.nodeSet;
    }

    public Set<T> getTargetSet(T object) {
        return this.targetMap.computeIfAbsent(object, e -> new HashSet());
    }

    public Set<T> getSourceSet(T object) {
        return this.sourceMap.computeIfAbsent(object, e -> new HashSet());
    }

    protected abstract void fillNodeTargetSourceSets(T var1);

    public Set<T> getFloorSet(int depth) {
        return this.depthNodeSetMap.get(depth);
    }

    public Integer getDepth(T node) {
        return this.nodeDepthMap.get(node);
    }

    public void populate(T rootObject) {
        this.nodeSet.clear();
        this.targetMap.clear();
        this.sourceMap.clear();
        this.floorList.clear();
        this.depthNodeSetMap.clear();
        this.nodeDepthMap.clear();
        this.fillNodeTargetSourceSets(rootObject);
        this.fillContainmentFloorList();
        this.computeDepthMap();
    }

    private void fillContainmentFloorList() {
        HashSet<T> rootFloorSet = new HashSet<T>();
        for (T object : this.nodeSet) {
            if (this.getSourceSet(object).size() != 0) continue;
            rootFloorSet.add(object);
        }
        HashSet<T> previousFloorSet = rootFloorSet;
        while (!previousFloorSet.isEmpty()) {
            this.depthNodeSetMap.put(this.floorList.size(), previousFloorSet);
            HashSet nextFloorSet = new HashSet();
            for (Object object : previousFloorSet) {
                for (Object contained : this.getTargetSet(object)) {
                    if (!this.nodeSet.contains(contained)) continue;
                    nextFloorSet.add(contained);
                }
            }
            this.floorList.add(previousFloorSet);
            previousFloorSet = nextFloorSet;
        }
    }

    private void computeDepthMap() {
        int depth = 0;
        for (Set<T> floorSet : this.floorList) {
            for (T object : floorSet) {
                this.nodeDepthMap.put(object, depth);
            }
            ++depth;
        }
    }
}

