/*
 * Decompiled with CFR 0.152.
 */
package plug.bpmn2.model;

import java.util.function.Consumer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EObject;
import plug.bpmn2.model.printer.BPMNPrinterShort;

public class BPMNLogger
extends Handler {
    private final Logger logger;
    private final BPMNPrinterShort shortPrinter;
    private Consumer<String> logOutput;

    public BPMNLogger(Consumer<String> logOutput) {
        this.logOutput = logOutput;
        this.logger = Logger.getLogger("BPMN");
        while (this.logger.getHandlers().length > 0) {
            this.logger.removeHandler(this.logger.getHandlers()[this.logger.getHandlers().length - 1]);
        }
        this.logger.setUseParentHandlers(false);
        this.logger.addHandler(this);
        this.shortPrinter = new BPMNPrinterShort();
    }

    public BPMNLogger() {
        this(System.out::println);
    }

    @Override
    public void publish(LogRecord record) {
        this.logOutput.accept(record.getMessage());
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    public void setOutput(Consumer<String> logOutput) {
        this.logOutput = logOutput;
    }

    private String getString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof EObject) {
            return this.shortPrinter.getShortString((EObject)object);
        }
        String className = object.getClass().getTypeName();
        String[] classNames = className.split("\\.");
        return classNames[classNames.length - 1];
    }

    private String getString(Level level, Object author, Object subject, Object text) {
        String subjectString;
        String textString;
        StringBuilder builder = new StringBuilder().append("[").append(level).append("]");
        String authorString = this.getString(author);
        if (authorString.length() > 0) {
            builder.append("[").append(authorString).append("]");
        }
        if ((textString = this.getString(text)).length() > 0) {
            builder.append(" ").append(textString);
        }
        if ((subjectString = this.getString(subject)).length() > 0) {
            builder.append(" <").append(subjectString).append(">");
        }
        return builder.toString();
    }

    public void log(Level level, Object author, Object subject, Object text) {
        this.logger.log(level, () -> this.getString(level, author, subject, text));
    }

    public void log(Object author, Object subject, Object text) {
        this.log(Level.INFO, author, subject, text);
    }

    public void log(String text) {
        this.logger.log(Level.INFO, text);
    }
}

