/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.pocs;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import obp2.bpmn2.model.BPMN2ProcessedModel;
import obp2.bpmn2.model.action.BPMN2FlowAction;
import obp2.bpmn2.model.token.Token;
import obp2.bpmn2.pocs.DANaiveExploration;
import obp2.bpmn2.pocs.EAFlowCompletionExploration;
import obp2.bpmn2.semantics.BPMN2ExecutionState;
import obp2.bpmn2.semantics.BPMN2Semantics;
import obp2.bpmn2.semantics.BPMN2SemanticsNaive;
import obp2.bpmn2.utils.BPMN2EmfUtils;
import org.eclipse.bpmn2.DocumentRoot;

public class FAAmnesicExploration {
    static BPMN2Semantics semantics = new BPMN2SemanticsNaive();

    public static boolean registerState(BPMN2ExecutionState state, Set<Integer> known, int cap) {
        int hash = Math.abs(state.hashCode()) % (cap * 10);
        return known.add(hash);
    }

    public static void pocExploration(BPMN2ProcessedModel model, boolean bfs, int cap, DANaiveExploration.NextFunction next) {
        HashSet<Integer> known = new HashSet<Integer>();
        LinkedList<BPMN2ExecutionState> toSee = new LinkedList<BPMN2ExecutionState>();
        BPMN2ExecutionState initial = new BPMN2ExecutionState(new int[0]);
        BPMN2FlowAction initialisation = model.getFlowActionPool().getFlowAction(0);
        initial = (BPMN2ExecutionState)((Object)semantics.execute(initial, initialisation).stream().findAny().get());
        FAAmnesicExploration.registerState(initial, known, cap);
        toSee.add(initial);
        LocalDateTime startTime = LocalDateTime.now();
        int count = 0;
        int maxWidth = 0;
        int maxToSee = 0;
        int maxTokens = 0;
        int[] maxTokensTokens = new int[]{};
        while (!toSee.isEmpty() && known.size() < cap) {
            BPMN2ExecutionState source;
            BPMN2ExecutionState bPMN2ExecutionState = source = bfs ? (BPMN2ExecutionState)((Object)toSee.removeFirst()) : (BPMN2ExecutionState)((Object)toSee.removeLast());
            if (source.tokens.length > maxTokens) {
                maxTokens = source.tokens.length;
                maxTokensTokens = source.tokens;
            }
            int width = 0;
            for (BPMN2FlowAction flowAction : model.getFlowActionPool().getFlowActionArray()) {
                if (source.tokens.length <= 0 || !semantics.canFire(source, flowAction)) continue;
                ++width;
                BPMN2ExecutionState target = next.compute(source, flowAction, model);
                if (!FAAmnesicExploration.registerState(target, known, cap)) continue;
                toSee.addLast(target);
            }
            if (width > maxWidth) {
                maxWidth = width;
            }
            if (toSee.size() > maxToSee) {
                maxToSee = toSee.size();
            }
            ++count;
        }
        Duration duration = Duration.between(startTime, LocalDateTime.now());
        int baseTokenCount = 0;
        for (int tokenId : maxTokensTokens) {
            Token token = model.getTokenPool().getToken(tokenId);
            if (token.getCallStack().size() != 0) continue;
            ++baseTokenCount;
        }
        int n = maxTokens - baseTokenCount;
        System.out.println((bfs ? "[BFS]" : "[DFS]") + count + " states, " + duration + ", maxWidth: " + maxWidth + ", maxFrontier: " + maxToSee + ", known: " + known.size() + ", maxTokens: " + baseTokenCount + (n > 0 ? "+" + n : ""));
    }

    public static void main(String[] args) {
        System.out.println("Loading ...");
        DocumentRoot documentRoot = BPMN2EmfUtils.getDocumentRoot("resources/tests/oneWay_reloaded.bpmn");
        BPMN2ProcessedModel model = new BPMN2ProcessedModel(documentRoot);
        System.out.println("Exploring ...");
        int cap = 100000;
        FAAmnesicExploration.pocExploration(model, true, cap, EAFlowCompletionExploration::flowCompletionNext);
        FAAmnesicExploration.pocExploration(model, false, cap, EAFlowCompletionExploration::flowCompletionNext);
    }
}

