/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.model.token;

import java.util.List;
import java.util.Objects;
import obp2.bpmn2.model.token.TokenPoolUtils;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.FlowNode;

public class Token {
    private final List<CallActivity> callStack;
    private final BaseElement placeBaseElement;
    private final FlowNode actionFlowNode;
    private int id;

    public Token(List<CallActivity> callStack, BaseElement placeBaseElement) {
        this.callStack = callStack;
        this.placeBaseElement = placeBaseElement;
        this.actionFlowNode = TokenPoolUtils.getActionFlowNodeFrom(placeBaseElement);
    }

    public List<CallActivity> getCallStack() {
        return this.callStack;
    }

    public BaseElement getPlaceBaseElement() {
        return this.placeBaseElement;
    }

    public FlowNode getActionFlowNode() {
        return this.actionFlowNode;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return this.callStack.equals(token.callStack) && this.placeBaseElement.equals(token.placeBaseElement);
    }

    public int hashCode() {
        return Objects.hash(this.callStack, this.placeBaseElement);
    }
}

