/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.extended.timed.interval;

import obp2.bpmn2.extended.timed.interval.Interval;

public class Intervals {
    public static final Interval EMPTY = new Interval(0, false, 0, false);

    private Intervals() {
    }

    public static Interval exact(int value) {
        if (value == Integer.MIN_VALUE || value == Integer.MAX_VALUE) {
            return EMPTY;
        }
        return new Interval(value, true, value, true);
    }

    public static Interval between(int min, boolean minIncluded, int max, boolean maxIncluded) {
        return new Interval(min, minIncluded, max, maxIncluded);
    }

    public static Interval atLeast(int minValue, boolean included) {
        if (minValue == Integer.MAX_VALUE) {
            return EMPTY;
        }
        return new Interval(minValue, included && minValue != Integer.MIN_VALUE, Integer.MAX_VALUE, false);
    }

    public static Interval atMost(int maxValue, boolean included) {
        if (maxValue == Integer.MIN_VALUE) {
            return EMPTY;
        }
        return new Interval(Integer.MIN_VALUE, false, maxValue, included && maxValue != Integer.MAX_VALUE);
    }

    public static Interval le(int value) {
        return Intervals.atMost(value, true);
    }

    public static Interval lt(int value) {
        return Intervals.atMost(value, false);
    }

    public static Interval ge(int value) {
        return Intervals.atLeast(value, true);
    }

    public static Interval gt(int value) {
        return Intervals.atLeast(value, false);
    }

    public static Interval parseInterval(String string) {
        int max;
        int min;
        if (string.length() < 3) {
            throw new IllegalArgumentException("string must be length >= 3");
        }
        boolean minIncluded = string.charAt(0) == '[';
        boolean maxIncluded = string.charAt(string.length() - 1) == ']';
        String[] minMaxString = string.substring(1, string.length() - 1).split(",");
        if (minMaxString.length != 2) {
            throw new IllegalArgumentException("string.split(',') must be length 2");
        }
        String minString = minMaxString[0].trim();
        String maxString = minMaxString[1].trim();
        try {
            min = Integer.parseInt(minString);
        }
        catch (NumberFormatException e) {
            min = Integer.MIN_VALUE;
        }
        try {
            max = Integer.parseInt(maxString);
        }
        catch (NumberFormatException e) {
            max = Integer.MAX_VALUE;
        }
        return new Interval(min, minIncluded, max, maxIncluded);
    }

    public static String toString(Interval interval) {
        boolean minIncluded = interval.isMinIncluded();
        int minValue = interval.getMinValue();
        boolean maxIncluded = interval.isMaxIncluded();
        int maxValue = interval.getMaxValue();
        return (minIncluded ? "[" : "]") + (minValue == Integer.MIN_VALUE ? "oo" : Integer.valueOf(minValue)) + "," + (maxValue == Integer.MAX_VALUE ? "oo" : Integer.valueOf(maxValue)) + (maxIncluded ? "]" : "[");
    }

    public static class Positive {
        public static final Interval ANY_VALUE = new Interval(0, true, Integer.MAX_VALUE, false);

        private Positive() {
        }

        public static Interval between(int min, boolean minIncluded, int max, boolean maxIncluded) {
            if (min < 0 || max < 0) {
                throw new IllegalArgumentException("Positive value expected");
            }
            return new Interval(min, minIncluded, max, maxIncluded);
        }

        public static Interval exact(int value) {
            return Positive.between(value, true, value, true);
        }

        public static Interval atLeast(int value, boolean included) {
            if (value == Integer.MAX_VALUE) {
                return EMPTY;
            }
            return Positive.between(value, included, Integer.MAX_VALUE, false);
        }

        public static Interval atMost(int value, boolean included) {
            if (value == Integer.MAX_VALUE) {
                return ANY_VALUE;
            }
            return Positive.between(0, true, value, included);
        }

        public static Interval le(int value) {
            return Positive.atMost(value, true);
        }

        public static Interval lt(int value) {
            return Positive.atMost(value, false);
        }

        public static Interval ge(int value) {
            return Positive.atLeast(value, true);
        }

        public static Interval gt(int value) {
            return Positive.atLeast(value, false);
        }
    }
}

