/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.extended.timed.dbm;

import java.util.Arrays;
import obp2.bpmn2.extended.timed.dbm.DBMInternals;

public class DBMOps {
    public static void close(short[] dbm) {
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        for (int k = 0; k <= nbClocks; ++k) {
            if (dbm[k * (nbClocks + 1) + k] == DBMInternals.EMPTINESS) continue;
            for (int i = 0; i <= nbClocks; ++i) {
                if (dbm[i * (nbClocks + 1) + i] == DBMInternals.EMPTINESS) continue;
                for (int j = 0; j <= nbClocks; ++j) {
                    if (i == j || dbm[j * (nbClocks + 1) + j] == DBMInternals.EMPTINESS) continue;
                    int ij = i * (nbClocks + 1) + j;
                    int ik = i * (nbClocks + 1) + k;
                    int kj = k * (nbClocks + 1) + j;
                    dbm[ij] = DBMInternals.min(dbm[ij], DBMInternals.add(dbm[ik], dbm[kj]));
                }
            }
        }
    }

    public static boolean isMarkedEmpty(short[] dbm) {
        return dbm[0] == DBMInternals.EMPTINESS;
    }

    public static void markEmpty(short[] dbm) {
        dbm[0] = DBMInternals.EMPTINESS;
    }

    public static boolean isEmpty(short[] dbm) {
        if (dbm == null) {
            return true;
        }
        if (DBMOps.isMarkedEmpty(dbm)) {
            return true;
        }
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        for (int i = 1; i <= nbClocks; ++i) {
            if (dbm[i * (nbClocks + 1) + i] == DBMInternals.EMPTINESS) continue;
            return false;
        }
        DBMOps.markEmpty(dbm);
        return true;
    }

    public static void andInvariant(short[] dbm, int x, int y, int m, boolean strict) {
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        short mInternal = DBMInternals.computeInternal(m, strict);
        DBMOps.andInvariant(nbClocks, dbm, x, y, mInternal);
    }

    public static void andInvariant(int nbClocks, short[] dbm, int x, int y, int m, boolean strict) {
        short mInternal = DBMInternals.computeInternal(m, strict);
        DBMOps.andInvariant(nbClocks, dbm, x, y, mInternal);
    }

    public static void andInvariant(short[] dbm, int x, int y, short mInternal) {
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        DBMOps.andInvariant(nbClocks, dbm, x, y, mInternal);
    }

    public static void andInvariant(int nbClocks, short[] dbm, int x, int y, short mInternal) {
        if (dbm[x * (nbClocks + 1) + x] != DBMInternals.EMPTINESS && dbm[y * (nbClocks + 1) + y] != DBMInternals.EMPTINESS) {
            DBMOps.and(nbClocks, dbm, x, y, mInternal);
        }
    }

    public static void andGuard(short[] dbm, int x, int y, int m, boolean strict) {
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        DBMOps.andGuard(nbClocks, dbm, x, y, m, strict);
    }

    public static void andGuard(short[] dbm, int x, int y, short mInternal) {
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        DBMOps.andGuard(nbClocks, dbm, x, y, mInternal);
    }

    private static void and(int nbClocks, short[] dbm, int x, int y, short mInternal) {
        if (DBMInternals.lessThan(DBMInternals.add(dbm[y * (nbClocks + 1) + x], mInternal), 0)) {
            dbm[0] = DBMInternals.EMPTINESS;
        } else if (DBMInternals.lessThan(mInternal, dbm[x * (nbClocks + 1) + y])) {
            dbm[x * (nbClocks + 1) + y] = mInternal;
            for (int i = 0; i <= nbClocks; ++i) {
                if (dbm[i * (nbClocks + 1) + i] == DBMInternals.EMPTINESS) continue;
                for (int j = 0; j <= nbClocks; ++j) {
                    short addIYJ;
                    if (i == j || dbm[j * (nbClocks + 1) + j] == DBMInternals.EMPTINESS) continue;
                    short addIXJ = DBMInternals.add(dbm[i * (nbClocks + 1) + x], dbm[x * (nbClocks + 1) + j]);
                    if (DBMInternals.lessThan(addIXJ, dbm[i * (nbClocks + 1) + j])) {
                        dbm[i * (nbClocks + 1) + j] = addIXJ;
                    }
                    if (!DBMInternals.lessThan(addIYJ = DBMInternals.add(dbm[i * (nbClocks + 1) + y], dbm[y * (nbClocks + 1) + j]), dbm[i * (nbClocks + 1) + j])) continue;
                    dbm[i * (nbClocks + 1) + j] = addIYJ;
                }
            }
        }
    }

    public static void andGuard(int nbClocks, short[] dbm, int x, int y, int m, boolean strict) {
        short mInternal = DBMInternals.computeInternal(m, strict);
        DBMOps.andGuard(nbClocks, dbm, x, y, mInternal);
    }

    public static void andGuard(int nbClocks, short[] dbm, int x, int y, short mInternal) {
        if (dbm[x * (nbClocks + 1) + x] == DBMInternals.EMPTINESS || dbm[y * (nbClocks + 1) + y] == DBMInternals.EMPTINESS) {
            dbm[0] = DBMInternals.EMPTINESS;
        } else {
            DBMOps.and(nbClocks, dbm, x, y, mInternal);
        }
    }

    public static void normalize(short[] dbm, short[] k) {
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        for (int i = 0; i <= nbClocks; ++i) {
            if (dbm[i * (nbClocks + 1) + i] == DBMInternals.EMPTINESS) continue;
            for (int j = 0; j <= nbClocks; ++j) {
                if (i == j || dbm[j * (nbClocks + 1) + j] == DBMInternals.EMPTINESS) continue;
                int index = i + (nbClocks + 1) + j;
                short internal = dbm[index];
                int value = DBMInternals.getValue(internal);
                boolean strict = DBMInternals.isStrict(internal);
                if (internal != Short.MAX_VALUE && value > k[i]) {
                    dbm[index] = Short.MAX_VALUE;
                    continue;
                }
                if (internal == Short.MAX_VALUE || value >= -k[j] && (value != -k[j] || strict)) continue;
                dbm[index] = DBMInternals.computeInternal(-k[j], true);
            }
        }
        DBMOps.close(dbm);
    }

    public static void delay(short[] dbm) {
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        for (int i = 1; i <= nbClocks; ++i) {
            if (dbm[i * (nbClocks + 1) + i] == DBMInternals.EMPTINESS) continue;
            dbm[i * (nbClocks + 1)] = Short.MAX_VALUE;
        }
    }

    public static void delay(short[] dbm, int clockIndex) {
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        if (dbm[clockIndex * (nbClocks + 1) + clockIndex] != DBMInternals.EMPTINESS) {
            dbm[clockIndex * (nbClocks + 1)] = Short.MAX_VALUE;
        }
    }

    public static void set(short[] dbm, int nbClocks, int clockIndex, int value) {
        for (int i = 0; i <= nbClocks; ++i) {
            if (i == clockIndex) {
                dbm[i * (nbClocks + 1) + i] = 0;
                continue;
            }
            if (dbm[i * (nbClocks + 1) + i] == DBMInternals.EMPTINESS) continue;
            dbm[clockIndex * (nbClocks + 1) + i] = DBMInternals.add(DBMInternals.computeInternal(value, false), dbm[i]);
            dbm[i * (nbClocks + 1) + clockIndex] = DBMInternals.add(DBMInternals.computeInternal(-value, false), dbm[i * (nbClocks + 1)]);
        }
    }

    public static void set(short[] dbm, int clockIndex, int value) {
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        DBMOps.set(dbm, nbClocks, clockIndex, value);
    }

    public static boolean isEnabled(short[] dbm, int clockIndex) {
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        return dbm[clockIndex * (nbClocks + 1) + clockIndex] != DBMInternals.EMPTINESS;
    }

    public static void enable(short[] dbm, int clockIndex) {
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        for (int i = 0; i <= nbClocks; ++i) {
            if (i == clockIndex) {
                dbm[i * (nbClocks + 1) + i] = 0;
                continue;
            }
            if (dbm[i * (nbClocks + 1) + i] == DBMInternals.EMPTINESS) continue;
            dbm[clockIndex * (nbClocks + 1) + i] = Short.MAX_VALUE;
            dbm[i * (nbClocks + 1) + clockIndex] = Short.MAX_VALUE;
        }
    }

    public static void disable(short[] dbm, int clockIndex) {
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        for (int i = 0; i <= nbClocks; ++i) {
            if (i == clockIndex) {
                dbm[i * (nbClocks + 1) + i] = DBMInternals.EMPTINESS;
                continue;
            }
            dbm[clockIndex * (nbClocks + 1) + i] = 0;
            dbm[i * (nbClocks + 1) + clockIndex] = 0;
        }
    }

    public static boolean inclusion(short[] dbm1, short[] dbm2) {
        if (dbm1.length != dbm2.length) {
            return false;
        }
        if (Arrays.equals(dbm1, dbm2)) {
            return true;
        }
        for (int i = 0; i < dbm1.length; ++i) {
            short v1 = dbm1[i];
            short v2 = dbm2[i];
            if (v1 == v2 || !DBMInternals.lessThan(v2, v1)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEnabled(short[] dbm, int nbClocks, int clockIndex) {
        return dbm[clockIndex * (nbClocks + 1) + clockIndex] != DBMInternals.EMPTINESS;
    }

    public static int getNumberOfActiveClocks(short[] dbm) {
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        int nb = 0;
        for (int i = 0; i <= nbClocks; ++i) {
            if (!DBMOps.isEnabled(dbm, nbClocks, i)) continue;
            ++nb;
        }
        return nb;
    }
}

