/*
 * Decompiled with CFR 0.152.
 */
package plug.bpmn2.semantics.transition.kinds;

import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.emf.ecore.EObject;
import plug.bpmn2.model.BPMNModelHandler;
import plug.bpmn2.semantics.state.BPMNRuntimeInstance;
import plug.bpmn2.semantics.state.BPMNRuntimeState;
import plug.bpmn2.semantics.state.instance.FlowElementsContainerInstance;
import plug.bpmn2.semantics.state.instance.data.Token;
import plug.bpmn2.semantics.transition.Transition;

public class TransitionGateway
extends Transition {
    private final Gateway baseElement;

    public TransitionGateway(BPMNModelHandler model, BPMNRuntimeState state, BPMNRuntimeInstance scope, Gateway baseElement) {
        super(model, state, scope);
        this.baseElement = baseElement;
    }

    public Gateway getBaseElement() {
        return this.baseElement;
    }

    @Override
    public boolean attempt(BPMNRuntimeState source, BPMNRuntimeState target) {
        BPMNRuntimeInstance scope = this.getScope(source);
        if (!(scope instanceof FlowElementsContainerInstance)) {
            throw new IllegalStateException("Illegal gateway scope (expected flow element container)");
        }
        FlowElementsContainerInstance container = (FlowElementsContainerInstance)scope;
        for (SequenceFlow sequenceFlow : this.baseElement.getIncoming()) {
            Token token = this.getModel().tokens.get(sequenceFlow);
            if (container.getTokenSet().contains(token)) continue;
            return false;
        }
        if (target != null) {
            Token token;
            FlowElementsContainerInstance targetContainer = (FlowElementsContainerInstance)this.getScope(target);
            for (SequenceFlow sequenceFlow : this.baseElement.getIncoming()) {
                token = this.getModel().tokens.get(sequenceFlow);
                targetContainer.getTokenSet().remove(token);
            }
            for (SequenceFlow sequenceFlow : this.baseElement.getOutgoing()) {
                token = this.getModel().tokens.get(sequenceFlow);
                targetContainer.getTokenSet().add(token);
            }
        }
        return true;
    }

    public String toString() {
        return "Go Through " + this.getModel().printer.getShortString((EObject)this.getBaseElement());
    }
}

