/*
 * Decompiled with CFR 0.152.
 */
package plug.bpmn2.model.printer;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.ConversationLink;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.ParticipantMultiplicity;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.util.Bpmn2Switch;
import org.eclipse.emf.ecore.EObject;
import plug.bpmn2.model.printer.BPMNPrinterShort;

public class BPMNModelPrinter {
    private static final String TAB = "    ";
    private final BPMNPrinterShort printerShort = new BPMNPrinterShort();
    private final InternalSwitch internalSwitch = new InternalSwitch();

    public String getString(DocumentRoot root) {
        String result = "";
        for (String line : (List)this.internalSwitch.doSwitch((EObject)root)) {
            result = result + line + "\n";
        }
        return result;
    }

    class InternalSwitch
    extends Bpmn2Switch<List<String>> {
        InternalSwitch() {
        }

        private void addWithTab(List<String> target, List<String> source) {
            for (String string : source) {
                target.add(BPMNModelPrinter.TAB + string);
            }
        }

        private void addRef(List<String> target, String fieldName, EObject ref) {
            String refString = ref == null ? "null" : BPMNModelPrinter.this.printerShort.getShortString(ref);
            target.add(BPMNModelPrinter.TAB + fieldName + " Ref: " + refString);
        }

        public List<String> caseDocumentRoot(DocumentRoot object) {
            LinkedList<String> result = new LinkedList<String>();
            for (RootElement rootElement : object.getDefinitions().getRootElements()) {
                result.addAll((Collection)this.doSwitch((EObject)rootElement));
            }
            return result;
        }

        public List<String> caseDefinitions(Definitions object) {
            LinkedList<String> result = new LinkedList<String>();
            for (RootElement rootElement : object.getRootElements()) {
                result.addAll((Collection)this.doSwitch((EObject)rootElement));
            }
            return result;
        }

        private void addFlowElements(List<String> target, FlowElementsContainer object) {
            for (FlowElement flowElement : object.getFlowElements()) {
                this.addWithTab(target, (List)this.doSwitch((EObject)flowElement));
            }
        }

        public List<String> caseProcess(Process object) {
            Object result = this.defaultCase((EObject)object);
            this.addFlowElements((List<String>)result, (FlowElementsContainer)object);
            return result;
        }

        public List<String> caseCollaboration(Collaboration object) {
            Object result = this.defaultCase((EObject)object);
            for (MessageFlow messageFlow : object.getMessageFlows()) {
                this.addWithTab((List<String>)result, (List)this.doSwitch((EObject)messageFlow));
            }
            for (Participant participant : object.getParticipants()) {
                this.addWithTab((List<String>)result, (List)this.doSwitch((EObject)participant));
            }
            return result;
        }

        public List<String> caseMessageFlow(MessageFlow object) {
            Object result = this.defaultCase((EObject)object);
            this.addRef((List<String>)result, "Source", (EObject)object.getSourceRef());
            this.addRef((List<String>)result, "Target", (EObject)object.getTargetRef());
            this.addRef((List<String>)result, "Message", (EObject)object.getMessageRef());
            return result;
        }

        public List<String> caseParticipant(Participant object) {
            Object result = this.defaultCase((EObject)object);
            ParticipantMultiplicity multiplicity = object.getParticipantMultiplicity();
            String multiplicityString = multiplicity == null ? "null" : "[" + multiplicity.getMaximum() + " - " + multiplicity.getMaximum() + "]";
            result.add("    Multiplicity: " + multiplicityString);
            this.addRef((List<String>)result, "Process", (EObject)object.getProcessRef());
            return result;
        }

        public List<String> caseSequenceFlow(SequenceFlow object) {
            Object result = this.defaultCase((EObject)object);
            this.addRef((List<String>)result, "Source", (EObject)object.getSourceRef());
            this.addRef((List<String>)result, "Target", (EObject)object.getTargetRef());
            return result;
        }

        public List<String> caseFlowNode(FlowNode object) {
            Object result = this.defaultCase((EObject)object);
            for (Lane lane : object.getLanes()) {
                this.addRef((List<String>)result, "Lane", (EObject)lane);
            }
            for (SequenceFlow incoming : object.getIncoming()) {
                this.addRef((List<String>)result, "Incoming Sequence Flow", (EObject)incoming);
            }
            for (SequenceFlow outgoing : object.getOutgoing()) {
                this.addRef((List<String>)result, "Outgoing Sequence Flow", (EObject)outgoing);
            }
            return result;
        }

        private void addInputs(List<String> target, List<DataInputAssociation> inputs) {
            for (DataInputAssociation input : inputs) {
                this.addRef(target, "Data Input Association", (EObject)input);
            }
        }

        private void addOutputs(List<String> target, List<DataOutputAssociation> outputs) {
            for (DataOutputAssociation output : outputs) {
                this.addRef(target, "Data Output Association", (EObject)output);
            }
        }

        public List<String> caseActivity(Activity object) {
            Object result = this.caseFlowNode((FlowNode)object);
            for (BoundaryEvent boundaryEvent : object.getBoundaryEventRefs()) {
                this.addRef((List<String>)result, "Boundary Event", (EObject)boundaryEvent);
            }
            this.addInputs((List<String>)result, object.getDataInputAssociations());
            this.addOutputs((List<String>)result, object.getDataOutputAssociations());
            return result;
        }

        public List<String> caseEvent(Event object) {
            Object result = this.caseFlowNode((FlowNode)object);
            for (ConversationLink conversationLink : object.getIncomingConversationLinks()) {
                this.addRef((List<String>)result, "Incoming Conversation Link", (EObject)conversationLink);
            }
            for (ConversationLink conversationLink : object.getOutgoingConversationLinks()) {
                this.addRef((List<String>)result, "Outgoing Conversation Link", (EObject)conversationLink);
            }
            return result;
        }

        public List<String> caseThrowEvent(ThrowEvent object) {
            Object result = this.caseEvent((Event)object);
            this.addInputs((List<String>)result, object.getDataInputAssociation());
            return result;
        }

        public List<String> caseCatchEvent(CatchEvent object) {
            Object result = this.caseEvent((Event)object);
            return (List)super.caseCatchEvent(object);
        }

        public List<String> caseSubProcess(SubProcess object) {
            Object result = this.caseActivity((Activity)object);
            this.addFlowElements((List<String>)result, (FlowElementsContainer)object);
            return result;
        }

        public List<String> defaultCase(EObject object) {
            LinkedList<String> result = new LinkedList<String>();
            result.add(BPMNModelPrinter.this.printerShort.getShortString(object));
            return result;
        }
    }
}

