/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.pocs;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.LinkedList;
import obp2.bpmn2.model.BPMN2ProcessedModel;
import obp2.bpmn2.model.action.BPMN2FlowAction;
import obp2.bpmn2.model.token.Token;
import obp2.bpmn2.semantics.BPMN2ExecutionState;
import obp2.bpmn2.semantics.BPMN2Semantics;
import obp2.bpmn2.semantics.BPMN2SemanticsNaive;
import obp2.bpmn2.utils.BPMN2EmfUtils;
import org.eclipse.bpmn2.DocumentRoot;

public class DANaiveExploration {
    static BPMN2Semantics semantics = new BPMN2SemanticsNaive();

    public static BPMN2ExecutionState naiveExecution(BPMN2ExecutionState source, BPMN2FlowAction action, BPMN2ProcessedModel model) {
        return (BPMN2ExecutionState)((Object)semantics.execute(source, action).stream().findAny().get());
    }

    public static void pocExploration(BPMN2ProcessedModel model, boolean bfs, int cap, NextFunction next) {
        HashSet<BPMN2ExecutionState> known = new HashSet<BPMN2ExecutionState>();
        LinkedList<BPMN2ExecutionState> toSee = new LinkedList<BPMN2ExecutionState>();
        BPMN2ExecutionState initial = new BPMN2ExecutionState(new int[0]);
        BPMN2FlowAction initialisation = model.getFlowActionPool().getFlowAction(0);
        initial = (BPMN2ExecutionState)((Object)semantics.execute(initial, initialisation).stream().findAny().get());
        known.add(initial);
        toSee.add(initial);
        LocalDateTime startTime = LocalDateTime.now();
        int count = 0;
        int maxWidth = 0;
        int maxToSee = 0;
        int maxTokens = 0;
        int nbDeadlock = 0;
        int[] maxTokensTokens = new int[]{};
        while (!toSee.isEmpty() && known.size() < cap) {
            BPMN2ExecutionState source;
            BPMN2ExecutionState bPMN2ExecutionState = source = bfs ? (BPMN2ExecutionState)((Object)toSee.removeFirst()) : (BPMN2ExecutionState)((Object)toSee.removeLast());
            if (source.tokens.length > maxTokens) {
                maxTokens = source.tokens.length;
                maxTokensTokens = source.tokens;
            }
            int width = 0;
            for (BPMN2FlowAction flowAction : model.getFlowActionPool().getFlowActionArray()) {
                if (source.tokens.length <= 0 || !semantics.canFire(source, flowAction)) continue;
                ++width;
                BPMN2ExecutionState target = next.compute(source, flowAction, model);
                if (!known.add(target)) continue;
                toSee.addLast(target);
            }
            if (width > maxWidth) {
                maxWidth = width;
            }
            if (width == 0 && source.tokens.length > 0) {
                ++nbDeadlock;
            }
            if (toSee.size() > maxToSee) {
                maxToSee = toSee.size();
            }
            ++count;
        }
        Duration duration = Duration.between(startTime, LocalDateTime.now());
        int baseTokenCount = 0;
        for (int tokenId : maxTokensTokens) {
            Token token = model.getTokenPool().getToken(tokenId);
            if (token.getCallStack().size() != 0) continue;
            ++baseTokenCount;
        }
        int n = maxTokens - baseTokenCount;
        System.out.println((bfs ? "[BFS]" : "[DFS]") + count + " states, " + duration + ", maxWidth: " + maxWidth + ", maxFrontier: " + maxToSee + ", known: " + known.size() + ", maxTokens: " + baseTokenCount + (n > 0 ? "+" + n : "") + ", nbDeadlocks: " + nbDeadlock);
    }

    public static void pocNaiveExploration(BPMN2ProcessedModel model, boolean bfs, int cap) {
        DANaiveExploration.pocExploration(model, bfs, cap, DANaiveExploration::naiveExecution);
    }

    public static void main(String[] args) {
        System.out.println("Loading ...");
        DocumentRoot documentRoot = BPMN2EmfUtils.getDocumentRoot("resources/tests/oneWay_reloaded.bpmn");
        BPMN2ProcessedModel model = new BPMN2ProcessedModel(documentRoot);
        System.out.println("Exploring ...");
        DANaiveExploration.pocNaiveExploration(model, true, 10000);
        DANaiveExploration.pocNaiveExploration(model, false, 10000);
    }

    @FunctionalInterface
    public static interface NextFunction {
        public BPMN2ExecutionState compute(BPMN2ExecutionState var1, BPMN2FlowAction var2, BPMN2ProcessedModel var3);
    }
}

