/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.model.propositions;

import obp2.bpmn2.model.BPMN2ProcessedModel;
import obp2.bpmn2.model.token.Token;
import obp2.bpmn2.semantics.BPMN2ExecutionState;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Process;

public class ConfigurationProps {
    private final BPMN2ProcessedModel model;
    private final BPMN2ExecutionState state;

    public ConfigurationProps(BPMN2ProcessedModel model, BPMN2ExecutionState state) {
        this.model = model;
        this.state = state;
    }

    public int tokensLength() {
        return this.state.tokens.length;
    }

    public boolean isTerminated() {
        return this.tokensLength() == 0;
    }

    public boolean hasActiveProcess(String processName) {
        for (int tokenId : this.state.tokens) {
            Token token = this.model.getTokenPool().getToken(tokenId);
            Process process = this.model.getProcess(token.getCallStack());
            if (!process.getName().equals(processName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveTask(String taskName) {
        for (int tokenId : this.state.tokens) {
            FlowNode task;
            Token token = this.model.getTokenPool().getToken(tokenId);
            if (!(token.getPlaceBaseElement() instanceof FlowNode) || !taskName.equals((task = (FlowNode)token.getPlaceBaseElement()).getName())) continue;
            return true;
        }
        return false;
    }
}

