/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.model.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import obp2.bpmn2.model.action.BPMN2FlowAction;
import obp2.bpmn2.model.signal.SignalData;
import obp2.bpmn2.model.signal.SignalReferences;
import obp2.bpmn2.model.token.TokenPool;
import obp2.bpmn2.utils.BPMN2TokenUtils;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.StartEvent;

class FlowActionFactory {
    private final TokenPool tokenPool;
    private final SignalData signalData;
    private final LinkedList<CallActivity> callStack;

    public FlowActionFactory(TokenPool tokenPool, SignalData signalData) {
        this.tokenPool = tokenPool;
        this.signalData = signalData;
        this.callStack = new LinkedList();
    }

    public void enterCallActivity(CallActivity callActivity) {
        this.callStack.addLast(callActivity);
    }

    public void exitCallActivity() {
        this.callStack.removeLast();
    }

    private int[] getConnectedTokens(FlowNode flowNode, boolean incoming) {
        List sequenceFlows = incoming ? flowNode.getIncoming() : flowNode.getOutgoing();
        ArrayList<Integer> tokenIdList = new ArrayList<Integer>();
        for (SequenceFlow sequenceFlow : sequenceFlows) {
            int outTokenId = this.tokenPool.getTokenId(this.callStack, (BaseElement)sequenceFlow);
            tokenIdList.add(outTokenId);
        }
        return BPMN2TokenUtils.toArray(tokenIdList);
    }

    private int[] getOutgoingTokens(FlowNode flowNode) {
        return this.getConnectedTokens(flowNode, false);
    }

    private int[] getIncomingTokens(FlowNode flowNode) {
        return this.getConnectedTokens(flowNode, true);
    }

    private List<Integer> getInitialTokens(Process process) {
        ArrayList<Integer> tokenList = new ArrayList<Integer>();
        for (FlowElement flowElement : process.getFlowElements()) {
            int[] outTokenIds;
            if (!(flowElement instanceof StartEvent)) continue;
            StartEvent startEvent = (StartEvent)flowElement;
            for (int token : outTokenIds = this.getOutgoingTokens((FlowNode)startEvent)) {
                tokenList.add(token);
            }
        }
        return tokenList;
    }

    public BPMN2FlowAction getInitialisation(Collection<Process> rootProcesses) {
        BPMN2FlowAction initialAction = new BPMN2FlowAction(BPMN2FlowAction.Type.INITIALISATION);
        initialAction.setFlowNode(null);
        ArrayList<Integer> initialTokens = new ArrayList<Integer>();
        for (Process process : rootProcesses) {
            initialTokens.addAll(this.getInitialTokens(process));
        }
        initialAction.setProducedTokens(initialTokens);
        return initialAction;
    }

    public Collection<BPMN2FlowAction> getTaskActions(FlowNode task) {
        int nodeTokenId = this.tokenPool.getTokenId(this.callStack, (BaseElement)task);
        if (nodeTokenId < 0) {
            throw new IllegalStateException("Didn't find any token matching task & callStack");
        }
        int[] nodeTokenIdArray = new int[]{nodeTokenId};
        ArrayList<BPMN2FlowAction> flowActionList = new ArrayList<BPMN2FlowAction>();
        for (SequenceFlow sequenceFlow : task.getIncoming()) {
            BPMN2FlowAction startTaskAction = new BPMN2FlowAction(BPMN2FlowAction.Type.START_TASK);
            startTaskAction.setFlowNode(task);
            startTaskAction.setMandatoryTokens(this.tokenPool.getTokenId(this.callStack, (BaseElement)sequenceFlow));
            startTaskAction.setProducedTokens(nodeTokenIdArray);
            flowActionList.add(startTaskAction);
        }
        BPMN2FlowAction endTaskAction = new BPMN2FlowAction(BPMN2FlowAction.Type.END_TASK);
        endTaskAction.setFlowNode(task);
        endTaskAction.setMandatoryTokens(nodeTokenIdArray);
        endTaskAction.setProducedTokens(this.getOutgoingTokens(task));
        flowActionList.add(endTaskAction);
        return flowActionList;
    }

    public Collection<BPMN2FlowAction> getCallActivityActions(CallActivity callActivity) {
        ArrayList<BPMN2FlowAction> flowActionList = new ArrayList<BPMN2FlowAction>();
        int activityTokenId = this.tokenPool.getTokenId(this.callStack, (BaseElement)callActivity);
        for (SequenceFlow sequenceFlow : callActivity.getIncoming()) {
            BPMN2FlowAction openAction = new BPMN2FlowAction(BPMN2FlowAction.Type.OPEN_PROCESS);
            openAction.setFlowNode((FlowNode)callActivity);
            openAction.setMandatoryTokens(this.tokenPool.getTokenId(this.callStack, (BaseElement)sequenceFlow));
            ArrayList<Integer> producedTokens = new ArrayList<Integer>();
            producedTokens.add(activityTokenId);
            if (callActivity.getCalledElementRef() instanceof Process) {
                Process calledProcess = (Process)callActivity.getCalledElementRef();
                this.enterCallActivity(callActivity);
                producedTokens.addAll(this.getInitialTokens(calledProcess));
                openAction.setExcludedTokens(this.tokenPool.getTokenIds(this.callStack));
                this.exitCallActivity();
            }
            openAction.setProducedTokens(producedTokens);
            flowActionList.add(openAction);
        }
        BPMN2FlowAction closeAction = new BPMN2FlowAction(BPMN2FlowAction.Type.CLOSE_PROCESS);
        closeAction.setFlowNode((FlowNode)callActivity);
        closeAction.setMandatoryTokens(activityTokenId);
        closeAction.setProducedTokens(this.getOutgoingTokens((FlowNode)callActivity));
        if (callActivity.getCalledElementRef() instanceof Process) {
            this.enterCallActivity(callActivity);
            closeAction.setExcludedTokens(this.tokenPool.getTokenIds(this.callStack));
            this.exitCallActivity();
        }
        flowActionList.add(closeAction);
        return flowActionList;
    }

    public Collection<BPMN2FlowAction> getEndEventActions(EndEvent endEvent) {
        ArrayList<BPMN2FlowAction> flowActionList = new ArrayList<BPMN2FlowAction>();
        for (SequenceFlow inc : endEvent.getIncoming()) {
            BPMN2FlowAction endEventAction = new BPMN2FlowAction(BPMN2FlowAction.Type.END_EVENT);
            endEventAction.setFlowNode((FlowNode)endEvent);
            endEventAction.setMandatoryTokens(this.tokenPool.getTokenId(this.callStack, (BaseElement)inc));
            flowActionList.add(endEventAction);
        }
        return flowActionList;
    }

    public List<BPMN2FlowAction> getThrowSignalAction(IntermediateThrowEvent throwEvent) {
        Object signal = this.signalData.getSignal((Event)throwEvent);
        CatchEvent[] catchEvents = this.signalData.getCatchEvents(signal);
        ArrayList<Integer> optionalTokenList = new ArrayList<Integer>();
        HashMap<Integer, int[]> optionalProducedTokenMap = new HashMap<Integer, int[]>();
        for (CatchEvent catchEvent : catchEvents) {
            for (SequenceFlow incoming : catchEvent.getIncoming()) {
                for (int tokenId : this.tokenPool.getTokenIds((BaseElement)incoming)) {
                    optionalTokenList.add(tokenId);
                    List<CallActivity> incomingCallStack = this.tokenPool.getToken(tokenId).getCallStack();
                    ArrayList<Integer> outgoingTokenList = new ArrayList<Integer>();
                    for (SequenceFlow outgoing : catchEvent.getOutgoing()) {
                        int outgoingTokenId = this.tokenPool.getTokenId(incomingCallStack, (BaseElement)outgoing);
                        if (outgoingTokenId < 0) {
                            throw new IllegalStateException("Could not find token id");
                        }
                        outgoingTokenList.add(outgoingTokenId);
                    }
                    optionalProducedTokenMap.put(tokenId, BPMN2TokenUtils.toArray(outgoingTokenList));
                }
            }
        }
        int[] optionalTokens = BPMN2TokenUtils.toArray(optionalTokenList);
        ArrayList<BPMN2FlowAction> throwActionList = new ArrayList<BPMN2FlowAction>();
        for (SequenceFlow inc : throwEvent.getIncoming()) {
            BPMN2FlowAction throwAction = new BPMN2FlowAction(BPMN2FlowAction.Type.THROW_SIGNAL);
            throwAction.setFlowNode((FlowNode)throwEvent);
            throwAction.setMandatoryTokens(this.tokenPool.getTokenId(this.callStack, (BaseElement)inc));
            throwAction.setOptionalTokens(optionalTokens);
            throwAction.setProducedTokens(this.getOutgoingTokens((FlowNode)throwEvent));
            throwAction.setOptionalProducedTokenMap(optionalProducedTokenMap);
            throwActionList.add(throwAction);
        }
        return throwActionList;
    }

    public BPMN2FlowAction getParallelGatewayAction(FlowNode gateway) {
        BPMN2FlowAction action = new BPMN2FlowAction(BPMN2FlowAction.Type.TRAVERSE_PAR_GATEWAY);
        action.setFlowNode(gateway);
        action.setMandatoryTokens(this.getIncomingTokens(gateway));
        action.setProducedTokens(this.getOutgoingTokens(gateway));
        return action;
    }

    public Collection<BPMN2FlowAction> getExclusiveGatewayActions(ExclusiveGateway gateway) {
        if (gateway.getOutgoing().size() != 1) {
            throw new IllegalStateException("Unsupported: exclusive gateway with multiple outgoing sequence flows");
        }
        SequenceFlow out = (SequenceFlow)gateway.getOutgoing().get(0);
        int outTokenId = this.tokenPool.getTokenId(this.callStack, (BaseElement)out);
        ArrayList<BPMN2FlowAction> flowActionList = new ArrayList<BPMN2FlowAction>();
        for (SequenceFlow inc : gateway.getIncoming()) {
            BPMN2FlowAction action = new BPMN2FlowAction(BPMN2FlowAction.Type.TRAVERSE_EXC_GATEWAY);
            action.setFlowNode((FlowNode)gateway);
            action.setMandatoryTokens(this.tokenPool.getTokenId(this.callStack, (BaseElement)inc));
            action.setProducedTokens(outTokenId);
            flowActionList.add(action);
        }
        return flowActionList;
    }

    public boolean doesNotHaveThrow(IntermediateCatchEvent catchEvent) {
        Object signal = this.signalData.getSignal((Event)catchEvent);
        SignalReferences signalReferences = this.signalData.getSignalReferencesMap().get(signal);
        return signalReferences.getThrowEvents().length == 0;
    }

    public List<BPMN2FlowAction> getThrowLessCatchActions(IntermediateCatchEvent catchEvent) {
        SequenceFlow out = (SequenceFlow)catchEvent.getOutgoing().get(0);
        ArrayList<BPMN2FlowAction> flowActionList = new ArrayList<BPMN2FlowAction>();
        for (SequenceFlow inc : catchEvent.getIncoming()) {
            BPMN2FlowAction action = new BPMN2FlowAction(BPMN2FlowAction.Type.TRAVERSE_THROW_LESS_CATCH);
            action.setFlowNode((FlowNode)catchEvent);
            action.setMandatoryTokens(this.tokenPool.getTokenId(this.callStack, (BaseElement)inc));
            action.setProducedTokens(this.getOutgoingTokens((FlowNode)catchEvent));
            flowActionList.add(action);
        }
        return flowActionList;
    }

    public boolean calledProcessHasTokens(FlowNode flowNode) {
        CallActivity callActivity = (CallActivity)flowNode;
        this.enterCallActivity(callActivity);
        List<Integer> tokens = this.getInitialTokens((Process)callActivity.getCalledElementRef());
        boolean result = true;
        if (tokens.size() == 0) {
            result = false;
        } else if (tokens.size() > 0 && tokens.get(0) == -1) {
            result = false;
        }
        this.exitCallActivity();
        return result;
    }
}

