/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.extended.timed.dbm;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import obp2.bpmn2.extended.timed.dbm.DBMInternals;
import obp2.bpmn2.extended.timed.dbm.DBMOps;

public class DBMPrinter {
    public static String toString(short[] dbm) {
        int i;
        if (dbm == null) {
            return "No clock constrains.";
        }
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        StringBuilder builder = new StringBuilder();
        builder.append("     |");
        for (i = 0; i <= nbClocks; ++i) {
            if (i == 0) {
                builder.append("  0 ");
            } else {
                builder.append("  c");
                builder.append(i);
                builder.append(" ");
            }
            builder.append("  |");
        }
        builder.append("\n");
        for (i = 0; i <= nbClocks; ++i) {
            if (i == 0) {
                builder.append("   0");
            } else {
                builder.append("  c");
                builder.append(i);
            }
            builder.append(" |");
            for (int j = 0; j <= nbClocks; ++j) {
                builder.append(" ");
                short internal = dbm[i * (nbClocks + 1) + j];
                if (i == j && internal == DBMInternals.EMPTINESS) {
                    builder.append("  X ");
                } else if (internal == Short.MAX_VALUE) {
                    builder.append(" oo ");
                } else {
                    builder.append(DBMInternals.isStrict(internal) ? " <" : "<=");
                    int value = DBMInternals.getValue(internal);
                    if (value >= 0) {
                        builder.append(" ");
                    }
                    builder.append(value);
                }
                builder.append(" | ");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String toConstrainString(short[] dbm) {
        int i;
        if (dbm == null) {
            return "oo";
        }
        if (DBMOps.isEmpty(dbm)) {
            return "empty";
        }
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        StringBuilder builder = new StringBuilder();
        for (i = 1; i <= nbClocks; ++i) {
            if (dbm[i * (nbClocks + 1) + i] == DBMInternals.EMPTINESS) continue;
            StringBuilder constrain = new StringBuilder();
            short miniInternal = dbm[i];
            if (miniInternal != Short.MAX_VALUE) {
                constrain.append(-DBMInternals.getValue(miniInternal));
                constrain.append(DBMInternals.isStrict(miniInternal) ? " < " : " <= ");
            }
            constrain.append("c");
            constrain.append(i);
            short maxiInternal = dbm[i * (nbClocks + 1)];
            if (maxiInternal != Short.MAX_VALUE) {
                constrain.append(DBMInternals.isStrict(maxiInternal) ? " < " : " <= ");
                constrain.append(DBMInternals.getValue(maxiInternal));
            }
            if (constrain.length() <= 4) continue;
            if (builder.length() > 0) {
                builder.append(" & ");
            }
            builder.append((CharSequence)constrain);
        }
        for (i = 1; i <= nbClocks; ++i) {
            if (dbm[i * (nbClocks + 1) + i] == DBMInternals.EMPTINESS) continue;
            for (int j = i + 1; j <= nbClocks; ++j) {
                if (dbm[j * (nbClocks + 1) + j] == DBMInternals.EMPTINESS) continue;
                StringBuilder constrain = new StringBuilder();
                boolean atLeastOneBound = false;
                short miniInternal = dbm[j * (nbClocks + 1) + i];
                if (miniInternal != Short.MAX_VALUE) {
                    atLeastOneBound = true;
                    constrain.append(-DBMInternals.getValue(miniInternal));
                    constrain.append(DBMInternals.isStrict(miniInternal) ? " < " : " <= ");
                }
                constrain.append("c");
                constrain.append(i);
                constrain.append(" - c");
                constrain.append(j);
                short maxiInternal = dbm[i * (nbClocks + 1) + j];
                if (maxiInternal != Short.MAX_VALUE) {
                    atLeastOneBound = true;
                    constrain.append(DBMInternals.isStrict(maxiInternal) ? " < " : " <= ");
                    constrain.append(DBMInternals.getValue(maxiInternal));
                }
                if (constrain.length() <= 4 || !atLeastOneBound) continue;
                if (builder.length() > 0) {
                    builder.append(" & ");
                }
                builder.append((CharSequence)constrain);
            }
        }
        if (builder.length() == 0) {
            builder.append("oo");
        }
        return builder.toString();
    }

    public static String toString(short[] dbm, int nbClocks, int clockIndex, String clockName) {
        if (DBMInternals.isEmpty(dbm, nbClocks, clockIndex)) {
            return clockName + " has no value";
        }
        StringBuilder builder = new StringBuilder();
        short miniInternal = DBMInternals.getMinInternal(dbm, nbClocks, clockIndex);
        if (miniInternal != Short.MAX_VALUE) {
            builder.append(-DBMInternals.getValue(miniInternal)).append(DBMInternals.isStrict(miniInternal) ? " < " : " <= ");
        }
        builder.append(clockName);
        short maxiInternal = DBMInternals.getMaxInternal(dbm, nbClocks, clockIndex);
        if (maxiInternal != Short.MAX_VALUE) {
            builder.append(DBMInternals.isStrict(maxiInternal) ? " < " : " <= ").append(DBMInternals.getValue(maxiInternal));
        }
        return builder.toString();
    }

    public static String toString(short[] dbm, int nbClocks, int c1, int c2, String c1Name, String c2Name) {
        String differenceName = c1Name + " - " + c2Name;
        if (DBMInternals.isEmpty(dbm, nbClocks, c1) || DBMInternals.isEmpty(dbm, nbClocks, c2)) {
            return "(" + differenceName + ") has no value";
        }
        StringBuilder builder = new StringBuilder();
        boolean atLeastOneBound = false;
        short miniInternal = DBMInternals.getMinInternal(dbm, nbClocks, c1, c2);
        if (miniInternal != Short.MAX_VALUE) {
            atLeastOneBound = true;
            builder.append(-DBMInternals.getValue(miniInternal));
            builder.append(DBMInternals.isStrict(miniInternal) ? " < " : " <= ");
        }
        builder.append(differenceName);
        short maxiInternal = DBMInternals.getMaxInternal(dbm, nbClocks, c1, c2);
        if (maxiInternal != Short.MAX_VALUE) {
            atLeastOneBound = true;
            builder.append(DBMInternals.isStrict(maxiInternal) ? " < " : " <= ");
            builder.append(DBMInternals.getValue(maxiInternal));
        }
        if (!atLeastOneBound) {
            return "(" + differenceName + ") can be anything";
        }
        return builder.toString();
    }

    public static String toTGF(short[] dbm) {
        if (dbm == null) {
            return "";
        }
        if (DBMOps.isEmpty(dbm)) {
            return "";
        }
        int nbClocks = DBMInternals.getNumberOfClocks(dbm.length);
        StringBuilder nodeBuilder = new StringBuilder();
        StringBuilder edgeBuilder = new StringBuilder();
        for (int i = 0; i <= nbClocks; ++i) {
            if (!DBMOps.isEnabled(dbm, nbClocks, i)) continue;
            nodeBuilder.append(i + " " + i + "\n");
            for (int j = i + 1; j <= nbClocks; ++j) {
                short maxiInternal;
                if (!DBMOps.isEnabled(dbm, nbClocks, j)) continue;
                short miniInternal = dbm[j * (nbClocks + 1) + i];
                if (miniInternal != Short.MAX_VALUE) {
                    edgeBuilder.append(j + " " + i);
                    edgeBuilder.append(DBMInternals.isStrict(miniInternal) ? " > " : " >= ");
                    edgeBuilder.append(-DBMInternals.getValue(miniInternal) + "\n");
                }
                if ((maxiInternal = dbm[i * (nbClocks + 1) + j]) == Short.MAX_VALUE) continue;
                edgeBuilder.append(i + " " + j);
                edgeBuilder.append(DBMInternals.isStrict(maxiInternal) ? " < " : " <= ");
                edgeBuilder.append(DBMInternals.getValue(maxiInternal) + "\n");
            }
        }
        return nodeBuilder.toString() + "\n#\n" + edgeBuilder.toString();
    }

    public static void toFileTFG(short[] dbm, int id) {
        String tgfString = DBMPrinter.toTGF(dbm);
        Path path = Paths.get("dbm" + id + ".tgf", new String[0]).toAbsolutePath();
        try {
            path.toFile().createNewFile();
            Files.write(path, tgfString.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

