/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.extended.timed.dbm;

import java.util.Arrays;
import obp2.bpmn2.extended.timed.dbm.DBMInternals;

public class DBMCreate {
    public static short[] allUnconstrained(int nbClocks) {
        short[] dbm = new short[DBMInternals.computeSize(nbClocks)];
        Arrays.fill(dbm, (short)Short.MAX_VALUE);
        for (int i = 0; i < dbm.length; i += nbClocks + 2) {
            dbm[i] = 0;
        }
        return dbm;
    }

    public static short[] allZero(int nbClocks) {
        short[] dbm = new short[DBMInternals.computeSize(nbClocks)];
        Arrays.fill(dbm, (short)0);
        return dbm;
    }

    public static short[] allDisabled(int nbClocks) {
        short[] dbm = new short[DBMInternals.computeSize(nbClocks)];
        Arrays.fill(dbm, (short)0);
        for (int i = 1; i <= nbClocks; ++i) {
            DBMInternals.setInternal(dbm, nbClocks, i, i, DBMInternals.EMPTINESS);
        }
        return dbm;
    }

    public static short[] copy(short[] dbm) {
        return dbm == null ? null : Arrays.copyOf(dbm, dbm.length);
    }

    public static short[] orderDrivenCopy(short[] previousDBM, int previousNbClocks, int nextNbClocks, int[] newPositions) {
        short[] nextDBM = DBMCreate.allDisabled(nextNbClocks);
        nextDBM[0] = previousDBM[0];
        for (int i = 1; i <= previousNbClocks; ++i) {
            int nextI = newPositions[i - 1];
            if (nextI < 1) continue;
            short previousInternal = DBMInternals.getInternal(previousDBM, previousNbClocks, i, 0);
            DBMInternals.setInternal(nextDBM, nextNbClocks, nextI, 0, previousInternal);
            previousInternal = DBMInternals.getInternal(previousDBM, previousNbClocks, 0, i);
            DBMInternals.setInternal(nextDBM, nextNbClocks, 0, nextI, previousInternal);
            previousInternal = DBMInternals.getInternal(previousDBM, previousNbClocks, i, i);
            DBMInternals.setInternal(nextDBM, nextNbClocks, nextI, nextI, previousInternal);
            for (int j = i + 1; j <= previousNbClocks; ++j) {
                int nextJ = newPositions[j - 1];
                if (nextJ < 1) continue;
                previousInternal = DBMInternals.getInternal(previousDBM, previousNbClocks, i, j);
                DBMInternals.setInternal(nextDBM, nextNbClocks, nextI, nextJ, previousInternal);
                previousInternal = DBMInternals.getInternal(previousDBM, previousNbClocks, j, i);
                DBMInternals.setInternal(nextDBM, nextNbClocks, nextJ, nextI, previousInternal);
            }
        }
        return nextDBM;
    }

    public static short[] safeOrderDrivenCopy(short[] previousDBM, int nextNbClocks, int[] newPositions) {
        int previousNbClocks = DBMInternals.getNumberOfClocks(previousDBM);
        if (newPositions.length != previousNbClocks) {
            throw new IllegalArgumentException("newPositions must be of length equal to previous number of clocks");
        }
        boolean[] marks = new boolean[nextNbClocks];
        for (int index : newPositions) {
            if (index > nextNbClocks) {
                throw new IllegalArgumentException("New indexes must be inferior or equal to nextNbClocks");
            }
            if (index <= 0) continue;
            if (marks[index - 1]) {
                throw new IllegalArgumentException("Two different clocks can not be copied into the same index");
            }
            marks[index - 1] = true;
        }
        return DBMCreate.orderDrivenCopy(previousDBM, previousNbClocks, nextNbClocks, newPositions);
    }
}

