/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.model.declarations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.declarations.ChannelDecl;
import org.cte.ABCD.model.declarations.ChannelTypeDecl;
import org.cte.ABCD.model.declarations.ConstantDecl;
import org.cte.ABCD.model.declarations.DeclarationWithConstants;
import org.cte.ABCD.model.declarations.DeclarationWithVariables;
import org.cte.ABCD.model.declarations.FunctionDecl;
import org.cte.ABCD.model.declarations.NamedDeclaration;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.ProcessInstance;
import org.cte.ABCD.model.declarations.TypeDecl;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.kernel.Declaration;
import org.cte.ABCD.model.kernel.Type;

public class ABCDSystem
implements NamedDeclaration,
DeclarationWithConstants,
DeclarationWithVariables {
    private final List<Type> coreTypesList = new ArrayList<Type>();
    private final List<TypeDecl> typesList = new ArrayList<TypeDecl>();
    private final List<ChannelTypeDecl> channelTypesList = new ArrayList<ChannelTypeDecl>();
    private final List<ChannelDecl> channelsList = new ArrayList<ChannelDecl>();
    private final List<FunctionDecl> functionsList = new ArrayList<FunctionDecl>();
    private final List<ProcessDecl> processesList = new ArrayList<ProcessDecl>();
    private final List<ProcessInstance> compositionList = new ArrayList<ProcessInstance>();
    private final List<Declaration> declarationsList = new ArrayList<Declaration>();
    private String name;
    private final List<ConstantDecl> constantsList = new ArrayList<ConstantDecl>();
    private final List<VariableDecl> variablesList = new ArrayList<VariableDecl>();

    public List<Type> getCoreTypesList() {
        return Collections.unmodifiableList(this.coreTypesList);
    }

    public int getCoreTypesCount() {
        return this.coreTypesList.size();
    }

    public Type getCoreTypes(int index) {
        if (index < 0 || index >= this.getCoreTypesCount()) {
            return null;
        }
        return this.coreTypesList.get(index);
    }

    public void addCoreTypes(Type newValue) {
        this.addCoreTypes(this.getCoreTypesCount(), newValue);
    }

    public void addCoreTypes(int index, Type newValue) {
        this.coreTypesList.add(index, newValue);
    }

    public Type setCoreTypes(int index, Type newValue) {
        return this.coreTypesList.set(index, newValue);
    }

    public void addAllCoreTypes(Collection<Type> toAddList) {
        for (Type newValue : toAddList) {
            this.addCoreTypes(this.getCoreTypesCount(), newValue);
        }
    }

    public void removeCoreTypes(Type value) {
        int index = this.coreTypesList.indexOf(value);
        if (index >= 0) {
            this.removeCoreTypes(index);
        }
    }

    public void removeCoreTypes(int index) {
        this.coreTypesList.remove(index);
    }

    public List<TypeDecl> getTypesList() {
        return Collections.unmodifiableList(this.typesList);
    }

    public int getTypesCount() {
        return this.typesList.size();
    }

    public TypeDecl getTypes(int index) {
        if (index < 0 || index >= this.getTypesCount()) {
            return null;
        }
        return this.typesList.get(index);
    }

    public void addTypes(TypeDecl newValue) {
        this.addTypes(this.getTypesCount(), newValue);
    }

    public void addTypes(int index, TypeDecl newValue) {
        this.typesList.add(index, newValue);
    }

    public TypeDecl setTypes(int index, TypeDecl newValue) {
        return this.typesList.set(index, newValue);
    }

    public void addAllTypes(Collection<TypeDecl> toAddList) {
        for (TypeDecl newValue : toAddList) {
            this.addTypes(this.getTypesCount(), newValue);
        }
    }

    public void removeTypes(TypeDecl value) {
        int index = this.typesList.indexOf(value);
        if (index >= 0) {
            this.removeTypes(index);
        }
    }

    public void removeTypes(int index) {
        this.typesList.remove(index);
    }

    public List<ChannelTypeDecl> getChannelTypesList() {
        return Collections.unmodifiableList(this.channelTypesList);
    }

    public int getChannelTypesCount() {
        return this.channelTypesList.size();
    }

    public ChannelTypeDecl getChannelTypes(int index) {
        if (index < 0 || index >= this.getChannelTypesCount()) {
            return null;
        }
        return this.channelTypesList.get(index);
    }

    public void addChannelTypes(ChannelTypeDecl newValue) {
        this.addChannelTypes(this.getChannelTypesCount(), newValue);
    }

    public void addChannelTypes(int index, ChannelTypeDecl newValue) {
        this.channelTypesList.add(index, newValue);
    }

    public ChannelTypeDecl setChannelTypes(int index, ChannelTypeDecl newValue) {
        return this.channelTypesList.set(index, newValue);
    }

    public void addAllChannelTypes(Collection<ChannelTypeDecl> toAddList) {
        for (ChannelTypeDecl newValue : toAddList) {
            this.addChannelTypes(this.getChannelTypesCount(), newValue);
        }
    }

    public void removeChannelTypes(ChannelTypeDecl value) {
        int index = this.channelTypesList.indexOf(value);
        if (index >= 0) {
            this.removeChannelTypes(index);
        }
    }

    public void removeChannelTypes(int index) {
        this.channelTypesList.remove(index);
    }

    public List<ChannelDecl> getChannelsList() {
        return Collections.unmodifiableList(this.channelsList);
    }

    public int getChannelsCount() {
        return this.channelsList.size();
    }

    public ChannelDecl getChannels(int index) {
        if (index < 0 || index >= this.getChannelsCount()) {
            return null;
        }
        return this.channelsList.get(index);
    }

    public void addChannels(ChannelDecl newValue) {
        this.addChannels(this.getChannelsCount(), newValue);
    }

    public void addChannels(int index, ChannelDecl newValue) {
        this.channelsList.add(index, newValue);
    }

    public ChannelDecl setChannels(int index, ChannelDecl newValue) {
        return this.channelsList.set(index, newValue);
    }

    public void addAllChannels(Collection<ChannelDecl> toAddList) {
        for (ChannelDecl newValue : toAddList) {
            this.addChannels(this.getChannelsCount(), newValue);
        }
    }

    public void removeChannels(ChannelDecl value) {
        int index = this.channelsList.indexOf(value);
        if (index >= 0) {
            this.removeChannels(index);
        }
    }

    public void removeChannels(int index) {
        this.channelsList.remove(index);
    }

    public List<FunctionDecl> getFunctionsList() {
        return Collections.unmodifiableList(this.functionsList);
    }

    public int getFunctionsCount() {
        return this.functionsList.size();
    }

    public FunctionDecl getFunctions(int index) {
        if (index < 0 || index >= this.getFunctionsCount()) {
            return null;
        }
        return this.functionsList.get(index);
    }

    public void addFunctions(FunctionDecl newValue) {
        this.addFunctions(this.getFunctionsCount(), newValue);
    }

    public void addFunctions(int index, FunctionDecl newValue) {
        this.functionsList.add(index, newValue);
    }

    public FunctionDecl setFunctions(int index, FunctionDecl newValue) {
        return this.functionsList.set(index, newValue);
    }

    public void addAllFunctions(Collection<FunctionDecl> toAddList) {
        for (FunctionDecl newValue : toAddList) {
            this.addFunctions(this.getFunctionsCount(), newValue);
        }
    }

    public void removeFunctions(FunctionDecl value) {
        int index = this.functionsList.indexOf(value);
        if (index >= 0) {
            this.removeFunctions(index);
        }
    }

    public void removeFunctions(int index) {
        this.functionsList.remove(index);
    }

    public List<ProcessDecl> getProcessesList() {
        return Collections.unmodifiableList(this.processesList);
    }

    public int getProcessesCount() {
        return this.processesList.size();
    }

    public ProcessDecl getProcesses(int index) {
        if (index < 0 || index >= this.getProcessesCount()) {
            return null;
        }
        return this.processesList.get(index);
    }

    public void addProcesses(ProcessDecl newValue) {
        this.addProcesses(this.getProcessesCount(), newValue);
    }

    public void addProcesses(int index, ProcessDecl newValue) {
        this.processesList.add(index, newValue);
    }

    public ProcessDecl setProcesses(int index, ProcessDecl newValue) {
        return this.processesList.set(index, newValue);
    }

    public void addAllProcesses(Collection<ProcessDecl> toAddList) {
        for (ProcessDecl newValue : toAddList) {
            this.addProcesses(this.getProcessesCount(), newValue);
        }
    }

    public void removeProcesses(ProcessDecl value) {
        int index = this.processesList.indexOf(value);
        if (index >= 0) {
            this.removeProcesses(index);
        }
    }

    public void removeProcesses(int index) {
        this.processesList.remove(index);
    }

    public List<ProcessInstance> getCompositionList() {
        return Collections.unmodifiableList(this.compositionList);
    }

    public int getCompositionCount() {
        return this.compositionList.size();
    }

    public ProcessInstance getComposition(int index) {
        if (index < 0 || index >= this.getCompositionCount()) {
            return null;
        }
        return this.compositionList.get(index);
    }

    public void addComposition(ProcessInstance newValue) {
        this.addComposition(this.getCompositionCount(), newValue);
    }

    public void addComposition(int index, ProcessInstance newValue) {
        this.compositionList.add(index, newValue);
    }

    public ProcessInstance setComposition(int index, ProcessInstance newValue) {
        return this.compositionList.set(index, newValue);
    }

    public void addAllComposition(Collection<ProcessInstance> toAddList) {
        for (ProcessInstance newValue : toAddList) {
            this.addComposition(this.getCompositionCount(), newValue);
        }
    }

    public void removeComposition(ProcessInstance value) {
        int index = this.compositionList.indexOf(value);
        if (index >= 0) {
            this.removeComposition(index);
        }
    }

    public void removeComposition(int index) {
        this.compositionList.remove(index);
    }

    public void addCompositionAndOpposite(ProcessInstance newValue) {
        this.addComposition(newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
    }

    public void addAllCompositionAndOpposite(Collection<ProcessInstance> toAddList) {
        for (ProcessInstance newValue : toAddList) {
            this.addCompositionAndOpposite(this.getCompositionCount(), newValue);
        }
    }

    public void addCompositionAndOpposite(int index, ProcessInstance newValue) {
        this.addComposition(index, newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
    }

    public ProcessInstance setCompositionAndOpposite(int index, ProcessInstance newValue) {
        ProcessInstance oldValue = this.compositionList.set(index, newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
        return oldValue;
    }

    public void removeCompositionAndOpposite(ProcessInstance removed) {
        this.removeComposition(removed);
        if (removed != null) {
            removed.setParent(null);
        }
    }

    public void removeCompositionAndOpposite(int index) {
        ProcessInstance removed = this.compositionList.get(index);
        this.removeComposition(index);
        if (removed != null) {
            removed.setParent(null);
        }
    }

    public List<Declaration> getDeclarationsList() {
        return Collections.unmodifiableList(this.declarationsList);
    }

    public int getDeclarationsCount() {
        return this.declarationsList.size();
    }

    public Declaration getDeclarations(int index) {
        if (index < 0 || index >= this.getDeclarationsCount()) {
            return null;
        }
        return this.declarationsList.get(index);
    }

    public void addDeclarations(Declaration newValue) {
        this.addDeclarations(this.getDeclarationsCount(), newValue);
    }

    public void addDeclarations(int index, Declaration newValue) {
        this.declarationsList.add(index, newValue);
    }

    public Declaration setDeclarations(int index, Declaration newValue) {
        return this.declarationsList.set(index, newValue);
    }

    public void addAllDeclarations(Collection<Declaration> toAddList) {
        for (Declaration newValue : toAddList) {
            this.addDeclarations(this.getDeclarationsCount(), newValue);
        }
    }

    public void removeDeclarations(Declaration value) {
        int index = this.declarationsList.indexOf(value);
        if (index >= 0) {
            this.removeDeclarations(index);
        }
    }

    public void removeDeclarations(int index) {
        this.declarationsList.remove(index);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    @Override
    public List<ConstantDecl> getConstantsList() {
        return Collections.unmodifiableList(this.constantsList);
    }

    @Override
    public int getConstantsCount() {
        return this.constantsList.size();
    }

    @Override
    public ConstantDecl getConstants(int index) {
        if (index < 0 || index >= this.getConstantsCount()) {
            return null;
        }
        return this.constantsList.get(index);
    }

    @Override
    public void addConstants(ConstantDecl newValue) {
        this.addConstants(this.getConstantsCount(), newValue);
    }

    @Override
    public void addConstants(int index, ConstantDecl newValue) {
        this.constantsList.add(index, newValue);
    }

    @Override
    public ConstantDecl setConstants(int index, ConstantDecl newValue) {
        return this.constantsList.set(index, newValue);
    }

    @Override
    public void addAllConstants(Collection<ConstantDecl> toAddList) {
        for (ConstantDecl newValue : toAddList) {
            this.addConstants(this.getConstantsCount(), newValue);
        }
    }

    @Override
    public void removeConstants(ConstantDecl value) {
        int index = this.constantsList.indexOf(value);
        if (index >= 0) {
            this.removeConstants(index);
        }
    }

    @Override
    public void removeConstants(int index) {
        this.constantsList.remove(index);
    }

    @Override
    public void addConstantsAndOpposite(ConstantDecl newValue) {
        this.addConstants(newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public void addAllConstantsAndOpposite(Collection<ConstantDecl> toAddList) {
        for (ConstantDecl newValue : toAddList) {
            this.addConstantsAndOpposite(this.getConstantsCount(), newValue);
        }
    }

    @Override
    public void addConstantsAndOpposite(int index, ConstantDecl newValue) {
        this.addConstants(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public ConstantDecl setConstantsAndOpposite(int index, ConstantDecl newValue) {
        ConstantDecl oldValue = this.constantsList.set(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
        return oldValue;
    }

    @Override
    public void removeConstantsAndOpposite(ConstantDecl removed) {
        this.removeConstants(removed);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public void removeConstantsAndOpposite(int index) {
        ConstantDecl removed = this.constantsList.get(index);
        this.removeConstants(index);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public List<VariableDecl> getVariablesList() {
        return Collections.unmodifiableList(this.variablesList);
    }

    @Override
    public int getVariablesCount() {
        return this.variablesList.size();
    }

    @Override
    public VariableDecl getVariables(int index) {
        if (index < 0 || index >= this.getVariablesCount()) {
            return null;
        }
        return this.variablesList.get(index);
    }

    @Override
    public void addVariables(VariableDecl newValue) {
        this.addVariables(this.getVariablesCount(), newValue);
    }

    @Override
    public void addVariables(int index, VariableDecl newValue) {
        this.variablesList.add(index, newValue);
    }

    @Override
    public VariableDecl setVariables(int index, VariableDecl newValue) {
        return this.variablesList.set(index, newValue);
    }

    @Override
    public void addAllVariables(Collection<VariableDecl> toAddList) {
        for (VariableDecl newValue : toAddList) {
            this.addVariables(this.getVariablesCount(), newValue);
        }
    }

    @Override
    public void removeVariables(VariableDecl value) {
        int index = this.variablesList.indexOf(value);
        if (index >= 0) {
            this.removeVariables(index);
        }
    }

    @Override
    public void removeVariables(int index) {
        this.variablesList.remove(index);
    }

    @Override
    public void addVariablesAndOpposite(VariableDecl newValue) {
        this.addVariables(newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public void addAllVariablesAndOpposite(Collection<VariableDecl> toAddList) {
        for (VariableDecl newValue : toAddList) {
            this.addVariablesAndOpposite(this.getVariablesCount(), newValue);
        }
    }

    @Override
    public void addVariablesAndOpposite(int index, VariableDecl newValue) {
        this.addVariables(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public VariableDecl setVariablesAndOpposite(int index, VariableDecl newValue) {
        VariableDecl oldValue = this.variablesList.set(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
        return oldValue;
    }

    @Override
    public void removeVariablesAndOpposite(VariableDecl removed) {
        this.removeVariables(removed);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public void removeVariablesAndOpposite(int index) {
        VariableDecl removed = this.variablesList.get(index);
        this.removeVariables(index);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public void accept(ABCDVisitor visitor) {
        visitor.visitABCDSystem(this);
    }

    public boolean equals(Object that) {
        return this.equalsCached(that, new IdentityHashMap<Object, Object>());
    }

    @Override
    public boolean equalsCached(Object that, IdentityHashMap<Object, Object> cache) {
        if (this == that) {
            cache.put(that, this);
            return true;
        }
        if (!(that instanceof ABCDSystem)) {
            return false;
        }
        Object o1 = cache.get(this);
        if (o1 != null) {
            return o1 == that;
        }
        Object o2 = cache.get(that);
        if (o2 != null) {
            return o2 == this;
        }
        return this.equalsFeatures((ABCDSystem)that, cache);
    }

    protected boolean equalsFeatures(ABCDSystem that, IdentityHashMap<Object, Object> cache) {
        int i;
        int l1size = 0;
        int l2size = 0;
        l1size = this.coreTypesList.size();
        if (l1size != (l2size = that.coreTypesList.size())) {
            return false;
        }
        for (i = 0; i < l1size; ++i) {
            if (this.coreTypesList.get(i).equalsCached(that.coreTypesList.get(i), cache)) continue;
            return false;
        }
        if (this.typesList != null) {
            if (that.typesList == null) {
                return false;
            }
            l1size = this.typesList.size();
            if (l1size != (l2size = that.typesList.size())) {
                return false;
            }
            for (i = 0; i < l1size; ++i) {
                if (this.typesList.get(i).equalsCached(that.typesList.get(i), cache)) continue;
                return false;
            }
        }
        if (this.channelTypesList != null) {
            if (that.channelTypesList == null) {
                return false;
            }
            l1size = this.channelTypesList.size();
            if (l1size != (l2size = that.channelTypesList.size())) {
                return false;
            }
            for (i = 0; i < l1size; ++i) {
                if (this.channelTypesList.get(i).equalsCached(that.channelTypesList.get(i), cache)) continue;
                return false;
            }
        }
        if (this.channelsList != null) {
            if (that.channelsList == null) {
                return false;
            }
            l1size = this.channelsList.size();
            if (l1size != (l2size = that.channelsList.size())) {
                return false;
            }
            for (i = 0; i < l1size; ++i) {
                if (this.channelsList.get(i).equalsCached(that.channelsList.get(i), cache)) continue;
                return false;
            }
        }
        if (this.functionsList != null) {
            if (that.functionsList == null) {
                return false;
            }
            l1size = this.functionsList.size();
            if (l1size != (l2size = that.functionsList.size())) {
                return false;
            }
            for (i = 0; i < l1size; ++i) {
                if (this.functionsList.get(i).equalsCached(that.functionsList.get(i), cache)) continue;
                return false;
            }
        }
        if ((l1size = this.processesList.size()) != (l2size = that.processesList.size())) {
            return false;
        }
        for (i = 0; i < l1size; ++i) {
            if (this.processesList.get(i).equalsCached(that.processesList.get(i), cache)) continue;
            return false;
        }
        l1size = this.compositionList.size();
        if (l1size != (l2size = that.compositionList.size())) {
            return false;
        }
        for (i = 0; i < l1size; ++i) {
            if (this.compositionList.get(i).equalsCached(that.compositionList.get(i), cache)) continue;
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.constantsList != null) {
            if (that.constantsList == null) {
                return false;
            }
            l1size = this.constantsList.size();
            if (l1size != (l2size = that.constantsList.size())) {
                return false;
            }
            for (i = 0; i < l1size; ++i) {
                if (this.constantsList.get(i).equalsCached(that.constantsList.get(i), cache)) continue;
                return false;
            }
        }
        if (this.variablesList != null) {
            if (that.variablesList == null) {
                return false;
            }
            l1size = this.variablesList.size();
            if (l1size != (l2size = that.variablesList.size())) {
                return false;
            }
            for (i = 0; i < l1size; ++i) {
                if (this.variablesList.get(i).equalsCached(that.variablesList.get(i), cache)) continue;
                return false;
            }
        }
        return true;
    }
}

