/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.ffi.try0;

import obp.explorer.runtime.util.NameUtil;
import obp.fiacre.model.Array;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatType;
import obp.fiacre.model.Record;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;

class Java2JniTypeExtractor
extends ModelVisitor.Stub {
    String jniType = "jobject";
    String jniSignature = "???object???";
    String jniGetter = "Object";
    boolean isPrimitive = false;
    boolean isArray = false;
    String packageName;

    Java2JniTypeExtractor() {
    }

    @Override
    public void visitBoolType(BoolType toVisit) {
        this.jniType = "jboolean";
        this.jniSignature = "Z";
        this.jniGetter = "Boolean";
        this.isPrimitive = true;
    }

    @Override
    public void visitIntType(IntType toVisit) {
        this.jniType = "jint";
        this.jniSignature = "I";
        this.jniGetter = "Int";
        this.isPrimitive = true;
    }

    @Override
    public void visitNatType(NatType toVisit) {
        this.jniType = "jint";
        this.jniSignature = "I";
        this.jniGetter = "Int";
        this.isPrimitive = true;
    }

    @Override
    public void visitInterval(Interval toVisit) {
        this.jniType = "jint";
        this.jniSignature = "I";
        this.jniGetter = "Int";
        this.isPrimitive = true;
    }

    @Override
    public void visitArray(Array toVisit) {
        toVisit.getType().accept(this);
        this.jniType = this.jniType + "Array";
        this.jniSignature = "[" + this.jniSignature;
        this.jniGetter = this.jniGetter + "Array";
        this.isPrimitive = false;
        this.isArray = true;
    }

    @Override
    public void visitTypeId(TypeId toVisit) {
        toVisit.getDecl().accept(this);
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        if (toVisit.getIs() instanceof Record) {
            String typeName = NameUtil.capName(toVisit.getName());
            this.jniSignature = "L" + this.packageName + "/" + typeName + ";";
        } else {
            toVisit.getIs().accept(this);
        }
    }
}

