/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.bitstate;

import java.util.Arrays;

public class UnboundedLinearScanSet {
    int capacity = 0x100000;
    int size;
    byte[][] items = new byte[this.capacity][];
    int hashSeed;
    boolean stopGrowing;

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    char add_rehash(byte[][] items, int capacity, byte[] element, int hash) {
        int idx = (hash > 0 ? hash : -hash) % capacity;
        if (items[idx] == null) {
            items[idx] = element;
            return '\u0000';
        }
        int start = idx;
        while (items[idx = (idx + 1) % capacity] != null && idx != start) {
        }
        if (items[idx] == null) {
            items[idx] = element;
            return '\u0000';
        }
        assert (idx == start);
        return '\u0002';
    }

    int grow_if_needed() {
        if (this.stopGrowing) {
            return 1;
        }
        if (this.capacity - this.size > Math.max(this.capacity / 4, 1)) {
            return 0;
        }
        byte[][] new_space = new byte[this.capacity * 2][];
        for (int i = 0; i < this.capacity; ++i) {
            byte[] element = this.items[i];
            if (element == null) continue;
            this.add_rehash(new_space, 2 * this.capacity, element, Arrays.hashCode(element));
        }
        this.capacity *= 2;
        this.items = new_space;
        return 0;
    }

    boolean add(byte[] element) {
        int hash = Arrays.hashCode(element);
        int idx = (hash > 0 ? hash : -hash) % this.capacity;
        if (this.items[idx] == null) {
            this.items[idx] = element;
            ++this.size;
            this.grow_if_needed();
            return true;
        }
        if (Arrays.equals(this.items[idx], element)) {
            return false;
        }
        int start = idx;
        while (this.items[idx = (idx + 1) % this.capacity] != null && !Arrays.equals(this.items[idx], element) && idx != start) {
        }
        if (this.items[idx] == null) {
            this.items[idx] = element;
            ++this.size;
            this.grow_if_needed();
            return true;
        }
        if (idx == start) {
            throw new RuntimeException("Hash set is full");
        }
        return false;
    }
}

