/*
 * Decompiled with CFR 0.152.
 */
package obp.util;

import obp.literal.AnyLiteral;
import obp.literal.ArrayLiteral;
import obp.literal.BooleanLiteral;
import obp.literal.ConstantReference;
import obp.literal.IntegerLiteral;
import obp.literal.Literal;
import obp.literal.LiteralField;
import obp.literal.LiteralVisitor;
import obp.literal.RecordLiteral;
import obp.literal.StringLiteral;
import obp.literal.UnionLiteral;

public class LiteralUtil
implements LiteralVisitor {
    private final StringBuilder string = new StringBuilder();

    public static String print(Literal predicate) {
        LiteralUtil util = new LiteralUtil();
        predicate.accept(util);
        return util.string.toString();
    }

    private LiteralUtil() {
    }

    @Override
    public void visitAnyLiteral(AnyLiteral toVisit) {
        this.string.append("any");
    }

    @Override
    public void visitStringLiteral(StringLiteral toVisit) {
        this.string.append('\"');
        this.string.append(toVisit.getValue());
        this.string.append('\"');
    }

    @Override
    public void visitBooleanLiteral(BooleanLiteral toVisit) {
        this.string.append(toVisit.isValue());
    }

    @Override
    public void visitIntegerLiteral(IntegerLiteral toVisit) {
        this.string.append(toVisit.getValue());
    }

    @Override
    public void visitConstantReference(ConstantReference toVisit) {
        this.string.append(toVisit.getName());
    }

    @Override
    public void visitArrayLiteral(ArrayLiteral toVisit) {
        this.string.append(toVisit.getTypeName());
        this.string.append("[");
        int startLength = this.string.length();
        for (Literal literal : toVisit.getValueList()) {
            if (this.string.length() > startLength) {
                this.string.append(", ");
            }
            literal.accept(this);
        }
        this.string.append("]");
    }

    @Override
    public void visitLiteralField(LiteralField toVisit) {
        this.string.append(toVisit.getName());
        this.string.append(" = ");
        toVisit.getValue().accept(this);
    }

    @Override
    public void visitRecordLiteral(RecordLiteral toVisit) {
        this.string.append(toVisit.getTypeName());
        this.string.append("{");
        int startLength = this.string.length();
        for (LiteralField literal : toVisit.getFieldList()) {
            if (this.string.length() > startLength) {
                this.string.append(", ");
            }
            literal.accept(this);
        }
        this.string.append("}");
    }

    @Override
    public void visitUnionLiteral(UnionLiteral toVisit) {
        this.string.append(toVisit.getTypeName());
        this.string.append(".");
        this.string.append(toVisit.getName());
        if (toVisit.getValue() != null) {
            this.string.append("(");
            toVisit.getValue().accept(this);
            this.string.append(")");
        }
    }
}

