/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.behaviour.transitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.behaviour.Transition;
import obp.if2.behaviour.actions.InputAction;
import obp.if2.data.Resource;
import obp.if2.data.constants.ConstantLiteral;
import obp.if2.data.variables.QuantifierVariable;

public abstract class ProcessTransition
extends Transition {
    private int priority;
    private final List<QuantifierVariable> quantifiersList = new ArrayList<QuantifierVariable>();
    private InputAction input;
    private final List<Resource> acquiredResourcesList = new ArrayList<Resource>();
    private ConstantLiteral probability;

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        if (this.priority != newValue) {
            this.priority = newValue;
        }
    }

    public List<QuantifierVariable> getQuantifiersList() {
        return Collections.unmodifiableList(this.quantifiersList);
    }

    public int getQuantifiersCount() {
        return this.quantifiersList.size();
    }

    public QuantifierVariable getQuantifiers(int index) {
        if (index < 0 || index >= this.getQuantifiersCount()) {
            return null;
        }
        return this.quantifiersList.get(index);
    }

    public void addQuantifiers(QuantifierVariable newValue) {
        this.addQuantifiers(this.getQuantifiersCount(), newValue);
    }

    public void addQuantifiers(int index, QuantifierVariable newValue) {
        this.quantifiersList.add(index, newValue);
    }

    public QuantifierVariable setQuantifiers(int index, QuantifierVariable newValue) {
        return this.quantifiersList.set(index, newValue);
    }

    public void addAllQuantifiers(Collection<QuantifierVariable> toAddList) {
        for (QuantifierVariable newValue : toAddList) {
            this.addQuantifiers(this.getQuantifiersCount(), newValue);
        }
    }

    public void removeQuantifiers(QuantifierVariable value) {
        int index = this.quantifiersList.indexOf(value);
        if (index >= 0) {
            this.removeQuantifiers(index);
        }
    }

    public void removeQuantifiers(int index) {
        this.quantifiersList.remove(index);
    }

    public InputAction getInput() {
        return this.input;
    }

    public void setInput(InputAction newValue) {
        if (this.input == null ? newValue != null : !this.input.equals(newValue)) {
            this.input = newValue;
        }
    }

    public List<Resource> getAcquiredResourcesList() {
        return Collections.unmodifiableList(this.acquiredResourcesList);
    }

    public int getAcquiredResourcesCount() {
        return this.acquiredResourcesList.size();
    }

    public Resource getAcquiredResources(int index) {
        if (index < 0 || index >= this.getAcquiredResourcesCount()) {
            return null;
        }
        return this.acquiredResourcesList.get(index);
    }

    public void addAcquiredResources(Resource newValue) {
        this.addAcquiredResources(this.getAcquiredResourcesCount(), newValue);
    }

    public void addAcquiredResources(int index, Resource newValue) {
        this.acquiredResourcesList.add(index, newValue);
    }

    public Resource setAcquiredResources(int index, Resource newValue) {
        return this.acquiredResourcesList.set(index, newValue);
    }

    public void addAllAcquiredResources(Collection<Resource> toAddList) {
        for (Resource newValue : toAddList) {
            this.addAcquiredResources(this.getAcquiredResourcesCount(), newValue);
        }
    }

    public void removeAcquiredResources(Resource value) {
        int index = this.acquiredResourcesList.indexOf(value);
        if (index >= 0) {
            this.removeAcquiredResources(index);
        }
    }

    public void removeAcquiredResources(int index) {
        this.acquiredResourcesList.remove(index);
    }

    public ConstantLiteral getProbability() {
        return this.probability;
    }

    public void setProbability(ConstantLiteral newValue) {
        if (this.probability == null ? newValue != null : !this.probability.equals(newValue)) {
            this.probability = newValue;
        }
    }

    @Override
    public abstract void accept(If2Visitor var1);
}

