/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.compiler;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import obp.explorer.runtime.util.NameUtil;
import obp.fiacre.checker.NodeAnalyzer;
import obp.fiacre.checker.type.CExisting;
import obp.fiacre.compiler.ClockBindingsGenerator;
import obp.fiacre.compiler.ExpressionGenerator;
import obp.fiacre.compiler.ProgramGenerator;
import obp.fiacre.compiler.StatementGenerator;
import obp.fiacre.compiler.TransitionGenerator;
import obp.fiacre.compiler.TypeGenerator;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.Exp;
import obp.fiacre.model.FiniteBound;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.MaxBound;
import obp.fiacre.model.MinBound;
import obp.fiacre.model.NodeDecl;
import obp.fiacre.model.ParamPortDecl;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.State;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Type;
import obp.fiacre.model.Variable;
import obp.fiacre.util.ExpressionUtil;
import obp.fiacre.util.StatementUtil;
import obp.fiacre.util.TypeUtil;
import org.xid.basics.generation.java.DependencyManager;
import org.xid.basics.generation.java.Java;
import org.xid.basics.generation.java.JavaContentHandler;

public abstract class NodeGenerator {
    protected final ProgramGenerator caller;
    protected final JavaContentHandler content;

    public NodeGenerator(ProgramGenerator caller) {
        this.caller = caller;
        this.content = caller.getContent();
    }

    public Map<Type, String> getTypeNames() {
        return this.caller.getTypeNames();
    }

    public ClockBindingsGenerator getClockBindingsGenerator() {
        return this.caller.getClockBindingsGenerator();
    }

    public NodeAnalyzer getNodeAnalyzer() {
        return this.caller.getNodeAnalyzer();
    }

    public ExpressionGenerator getExpressionGenerator() {
        return this.caller.getExpressionGenerator();
    }

    public StatementGenerator getStatementGenerator() {
        return this.caller.getStatementGenerator();
    }

    public TransitionGenerator getTransitionGenerator() {
        return this.caller.getTransitionGenerator();
    }

    public TypeGenerator getTypeGenerator() {
        return this.caller.getTypeGenerator();
    }

    public DependencyManager getDependencyManager() {
        return this.caller.getDependencyManager();
    }

    protected boolean isConfigurationVariable(Variable variable) {
        return this.caller.getVariableAnalyser().isConfigurationVariable(variable);
    }

    protected boolean isBehaviorVariable(Variable variable) {
        return this.caller.getVariableAnalyser().isBehaviorVariable(variable);
    }

    protected void generateConfigurationFields(NodeDecl node) {
        if (node instanceof ProcessDecl) {
            this.content.beginAttribute(4, "short", "state");
            this.content.endAttribute("state");
        }
        for (LocalVariable variable : node.getVarList()) {
            if (!this.isConfigurationVariable(variable)) continue;
            String name = NameUtil.uncapName(variable.getName());
            String typeDeclaration = TypeUtil.toJavaDeclaration(variable.getType(), this.getTypeNames());
            this.content.beginAttribute(4, typeDeclaration, name);
            this.content.endAttribute(name);
        }
    }

    private Set<ArgumentVariable> collectReferenceArguments(List<LocalVariable> vars) {
        HashSet<ArgumentVariable> result = new HashSet<ArgumentVariable>();
        for (LocalVariable var : vars) {
            Exp initializer = var.getInitializer();
            if (initializer == null) continue;
            for (Variable referenced : ExpressionUtil.findUsedVariables(initializer)) {
                ArgumentVariable argument;
                if (!(referenced instanceof ArgumentVariable) || !(argument = (ArgumentVariable)referenced).isRef()) continue;
                result.add(argument);
            }
        }
        return result;
    }

    protected void generateConfigurationConstructors(NodeDecl node) {
        String name;
        String instanceName = ProgramGenerator.getConfigurationName(node);
        this.content.comment(1, 0, "Create initial configuration");
        Set<ArgumentVariable> referencedSharedVariableList = this.collectReferenceArguments(node.getVarList());
        referencedSharedVariableList.addAll(this.collectReferenceArguments(node.getInitAction()));
        Java.Parameter[] params = new Java.Parameter[referencedSharedVariableList.size()];
        if (referencedSharedVariableList.size() > 0) {
            int i = 0;
            for (ArgumentVariable argument : referencedSharedVariableList) {
                String name2 = NameUtil.uncapName(argument.getName());
                String typeDeclaration = TypeUtil.toJavaDeclaration(argument.getType(), this.caller.getTypeNames());
                params[i++] = new Java.Parameter(0, typeDeclaration, name2);
            }
        }
        if (node instanceof ProcessDecl) {
            this.content.beginMethod(4, null, instanceName, null, new Java.Parameter[0]);
            if (referencedSharedVariableList.size() > 0) {
                this.content.endMethod(instanceName);
                this.content.beginMethod(4, null, instanceName, null, params);
                this.content.codeln(0, "this.state = 0;");
            }
        } else {
            this.content.beginMethod(4, null, instanceName, null, new Java.Parameter[0]);
        }
        for (LocalVariable variable : node.getVarList()) {
            if (!this.isConfigurationVariable(variable)) continue;
            name = NameUtil.uncapName(variable.getName());
            if (variable.getInitializer() == null) {
                this.content.codeln(0, "this." + name + " = " + this.getTypeGenerator().generateJavaInitialValue(variable.getType(), this.caller.getTypeNames()) + ";");
                continue;
            }
            CExisting cExisting = new CExisting(variable.getType());
            this.content.codeln(0, "this." + name + " = " + this.getExpressionGenerator().generateForBehavior(cExisting, variable.getInitializer()) + ";");
        }
        this.content.endMethod(instanceName);
        this.content.comment(1, 0, "Create configuration as a copy");
        this.content.beginMethod(4, null, instanceName, null, new Java.Parameter[]{new Java.Parameter(0, instanceName, "other")});
        if (node instanceof ProcessDecl) {
            this.content.codeln(0, "this.state = other.state;");
        }
        for (LocalVariable variable : node.getVarList()) {
            if (!this.isConfigurationVariable(variable)) continue;
            name = NameUtil.uncapName(variable.getName());
            this.getTypeGenerator().copyCode(0, variable.getType(), "this." + name, "other." + name);
        }
        this.content.endMethod(instanceName);
    }

    protected void generateConfigurationEqualsAndHashCode(NodeDecl node) {
        String name;
        String instanceName = ProgramGenerator.getConfigurationName(node);
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "boolean", "equals", null, new Java.Parameter[]{new Java.Parameter(0, "Object", "object")});
        this.content.codeln(0, "if (object instanceof " + instanceName + ") {");
        this.content.codeln(1, instanceName + " other = (" + instanceName + ") object;");
        if (node instanceof ProcessDecl) {
            this.content.codeln(1, "if (state != other.state) return false;");
        }
        for (LocalVariable variable : node.getVarList()) {
            if (!this.isConfigurationVariable(variable)) continue;
            name = NameUtil.uncapName(variable.getName());
            this.getTypeGenerator().generateEqualsCode(name, variable.getType());
        }
        this.content.codeln(1, "return true;");
        this.content.codeln(0, "}");
        this.content.codeln(0, "return false;");
        this.content.endMethod("equals");
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "int", "hashCode", null, new Java.Parameter[0]);
        this.content.codeln(0, "int total = 17;");
        if (node instanceof ProcessDecl) {
            this.content.codeln(0, "total = total * 37 + state;");
        }
        for (LocalVariable variable : node.getVarList()) {
            if (!this.isConfigurationVariable(variable)) continue;
            name = NameUtil.uncapName(variable.getName());
            this.getTypeGenerator().generateHashcodeCode(name, variable.getType());
        }
        this.content.codeln(0, "return total;");
        this.content.endMethod("hashCode");
    }

    protected void generateIdSeedField() {
        this.content.beginAttribute(9, "short", "idSeed");
        this.content.code("1");
        this.content.endAttribute("idSeed");
    }

    protected void generateBehaviorFields(NodeDecl node) {
        String name;
        for (String informal : this.getNodeAnalyzer().getInformalsForProcess(node)) {
            name = "informal" + this.getNodeAnalyzer().getInformalMap().get(informal);
            this.content.beginAttribute(17, "short", name);
            this.content.endAttribute(name);
        }
        for (ParamPortDecl port : node.getPortList()) {
            name = NameUtil.uncapName(port.getName());
            String broadcastShortname = this.getDependencyManager().getShortName("obp.explorer.runtime.core.BroadcastChannel");
            this.content.beginAttribute(17, broadcastShortname, name);
            this.content.endAttribute(name);
        }
        for (ArgumentVariable parameter : node.getArgList()) {
            int flags = 1;
            String name2 = NameUtil.uncapName(parameter.getName());
            Type type = TypeUtil.referencedType(parameter.getType());
            String typeDeclaration = TypeUtil.toJavaDeclaration(type, this.getTypeNames());
            if (parameter.isRef()) {
                String referencedArgumentImport = "obp.explorer.runtime.ReferencedArgument";
                String referencedArgumentDeclaration = "ReferencedArgument<" + typeDeclaration + ">";
                if (TypeUtil.isIntegerType(type)) {
                    referencedArgumentImport = "obp.explorer.runtime.ReferencedArgumentInt";
                    referencedArgumentDeclaration = "ReferencedArgumentInt";
                } else if (type instanceof BoolType) {
                    referencedArgumentImport = "obp.explorer.runtime.ReferencedArgumentBoolean";
                    referencedArgumentDeclaration = "ReferencedArgumentBoolean";
                }
                this.getDependencyManager().getShortName(referencedArgumentImport);
                flags |= 0x10;
                name2 = name2 + "Ref";
                typeDeclaration = referencedArgumentDeclaration;
            }
            this.content.beginAttribute(flags, typeDeclaration, name2);
            this.content.endAttribute(name2);
        }
        for (LocalVariable variable : node.getVarList()) {
            if (!this.isBehaviorVariable(variable)) continue;
            String name3 = NameUtil.uncapName(variable.getName());
            String typeDeclaration = TypeUtil.toJavaDeclaration(variable.getType(), this.getTypeNames());
            this.content.beginAttribute(4, typeDeclaration, name3);
            this.content.endAttribute(name3);
        }
    }

    protected void generateBehaviorConstructorsStart(NodeDecl node) {
        String name;
        int i;
        String name2;
        int i2;
        this.getDependencyManager().getShortName("obp.explorer.runtime.SymbolsTable");
        String instanceName = ProgramGenerator.getBehaviorName(node);
        Java.Parameter[] constructorParametersArray = new Java.Parameter[1 + node.getPortCount() + node.getArgCount()];
        constructorParametersArray[0] = new Java.Parameter(0, "SymbolsTable", "symbols");
        int delta = 1;
        for (i2 = 0; i2 < node.getPortCount(); ++i2) {
            ParamPortDecl port = node.getPort(i2);
            name2 = NameUtil.uncapName(port.getName());
            String broadcastShortname = this.getDependencyManager().getShortName("obp.explorer.runtime.core.BroadcastChannel");
            constructorParametersArray[i2 + delta] = new Java.Parameter(0, broadcastShortname, name2);
        }
        delta += node.getPortCount();
        for (i2 = 0; i2 < node.getArgCount(); ++i2) {
            ArgumentVariable parameter = node.getArg(i2);
            name2 = NameUtil.uncapName(parameter.getName());
            Type type = TypeUtil.referencedType(parameter.getType());
            String typeDeclaration = TypeUtil.toJavaDeclaration(type, this.getTypeNames());
            if (parameter.isRef()) {
                String referencedArgumentImport = "obp.explorer.runtime.ReferencedArgument";
                String referencedArgumentDeclaration = "ReferencedArgument<" + typeDeclaration + ">";
                if (TypeUtil.isIntegerType(type)) {
                    referencedArgumentImport = "obp.explorer.runtime.ReferencedArgumentInt";
                    referencedArgumentDeclaration = "ReferencedArgumentInt";
                } else if (type instanceof BoolType) {
                    referencedArgumentImport = "obp.explorer.runtime.ReferencedArgumentBoolean";
                    referencedArgumentDeclaration = "ReferencedArgumentBoolean";
                }
                this.getDependencyManager().getShortName(referencedArgumentImport);
                typeDeclaration = referencedArgumentDeclaration;
            }
            constructorParametersArray[i2 + delta] = new Java.Parameter(0, typeDeclaration, name2);
        }
        this.content.beginMethod(4, null, instanceName, null, constructorParametersArray);
        this.content.codeln(0, "super(\"" + node.getName() + "\", idSeed++, symbols);");
        String inputChannelString = "";
        String outputChannelString = "";
        for (i = 0; i < node.getPortCount(); ++i) {
            ParamPortDecl port = node.getPort(i);
            name = NameUtil.uncapName(port.getName());
            this.content.codeln(0, "this." + name + " = " + name + ";");
            if (node.getPort(i).isIn()) {
                inputChannelString = inputChannelString + "this." + name + ", ";
                continue;
            }
            outputChannelString = outputChannelString + "this." + name + ", ";
        }
        if (inputChannelString.length() > 0) {
            this.content.codeln(0, "inputChannels = new Channel[]{" + inputChannelString.substring(0, inputChannelString.length() - 2) + "};");
        }
        if (outputChannelString.length() > 0) {
            this.content.codeln(0, "outputChannels = new Channel[]{" + outputChannelString.substring(0, outputChannelString.length() - 2) + "};");
        }
        for (i = 0; i < node.getArgCount(); ++i) {
            String leftName;
            ArgumentVariable parameter = node.getArg(i);
            String rightName = leftName = NameUtil.uncapName(parameter.getName());
            if (parameter.isRef()) {
                leftName = leftName + "Ref";
            }
            this.content.codeln(0, "this." + leftName + " = " + rightName + ";");
        }
        for (LocalVariable variable : node.getVarList()) {
            if (!this.isBehaviorVariable(variable)) continue;
            name = NameUtil.uncapName(variable.getName());
            if (variable.getInitializer() == null) {
                this.content.codeln(0, "this." + name + " = " + this.getTypeGenerator().generateJavaInitialValue(variable.getType(), this.caller.getTypeNames()) + ";");
                continue;
            }
            CExisting cExisting = new CExisting(variable.getType());
            this.content.codeln(0, "this." + name + " = " + this.getExpressionGenerator().generateForBehavior(cExisting, variable.getInitializer()) + ";");
        }
        for (String informal : this.getNodeAnalyzer().getInformalsForProcess(node)) {
            name = "informal" + this.getNodeAnalyzer().getInformalMap().get(informal);
            this.content.codeln(0, name + " = symbols.getInformalId(\"" + informal + "\");");
        }
    }

    protected void generateBehaviorConstructorsEnd(NodeDecl node) {
        String instanceName = ProgramGenerator.getBehaviorName(node);
        this.content.endMethod(instanceName);
    }

    protected void generateBehaviorReadWriteConfigurationMethod(NodeDecl node) {
        String name;
        this.getDependencyManager().getShortName("obp.explorer.runtime.BehaviorConfiguration");
        this.getDependencyManager().getShortName("org.xid.basics.serializer.Boost");
        String processConfigurationName = ProgramGenerator.getConfigurationName(node);
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "BehaviorConfiguration", "readConfiguration", null, new Java.Parameter[]{new Java.Parameter(0, "Boost", "boost")});
        this.content.codeln(0, processConfigurationName + " me = new " + processConfigurationName + "();");
        if (node instanceof ProcessDecl) {
            this.content.codeln(0, "me.state = boost.readShort();");
        }
        for (LocalVariable variable : node.getVarList()) {
            if (!this.isConfigurationVariable(variable)) continue;
            name = NameUtil.uncapName(variable.getName());
            this.getTypeGenerator().boostReadCode(0, variable.getType(), "me." + name);
        }
        this.content.codeln(0, "return me;");
        this.content.endMethod("readConfiguration");
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "void", "writeConfiguration", null, new Java.Parameter[]{new Java.Parameter(0, "Boost", "boost"), new Java.Parameter(0, "BehaviorConfiguration", "processConfiguration")});
        this.content.codeln(0, processConfigurationName + " me = (" + processConfigurationName + ") processConfiguration;");
        if (node instanceof ProcessDecl) {
            this.content.codeln(0, "boost.writeShort(me.state);");
        }
        for (LocalVariable variable : node.getVarList()) {
            if (!this.isConfigurationVariable(variable)) continue;
            name = NameUtil.uncapName(variable.getName());
            this.getTypeGenerator().boostWriteCode(0, variable.getType(), "me." + name);
        }
        this.content.endMethod("writeConfiguration");
    }

    private Set<ArgumentVariable> collectReferenceArguments(Statement action) {
        HashSet<ArgumentVariable> result = new HashSet<ArgumentVariable>();
        for (Variable referenced : StatementUtil.findUsedVariables(action)) {
            ArgumentVariable argument;
            if (!(referenced instanceof ArgumentVariable) || !(argument = (ArgumentVariable)referenced).isRef()) continue;
            result.add(argument);
        }
        return result;
    }

    protected void generateBehaviorInitialConfigurationMethod(NodeDecl node) {
        String typeDeclaration;
        String name;
        this.getDependencyManager().getShortName("obp.explorer.runtime.BehaviorConfiguration");
        String processConfigurationName = ProgramGenerator.getConfigurationName(node);
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "BehaviorConfiguration", "createInitialConfiguration", null, new Java.Parameter[]{new Java.Parameter(0, "Configuration", "conf")});
        Set<ArgumentVariable> referencedSharedVariableList = this.collectReferenceArguments(node.getInitAction());
        String args = "";
        if (referencedSharedVariableList.size() > 0) {
            for (ArgumentVariable argument : referencedSharedVariableList) {
                name = NameUtil.uncapName(argument.getName());
                typeDeclaration = TypeUtil.toJavaDeclaration(argument.getType(), this.caller.getTypeNames());
                this.content.codeln(0, typeDeclaration + " " + name + " = " + name + "Ref.get(conf);");
                args = args + name + ", ";
            }
        }
        if (node instanceof ProcessDecl && referencedSharedVariableList.size() > 0) {
            this.content.codeln(0, processConfigurationName + " me = new " + processConfigurationName + "(" + args.substring(0, args.length() - 2) + ");");
        } else {
            this.content.codeln(0, processConfigurationName + " me = new " + processConfigurationName + "();");
        }
        for (LocalVariable variable : node.getVarList()) {
            if (!this.caller.getVariableAnalyser().isLocalToTransitions(variable)) continue;
            name = NameUtil.uncapName(variable.getName());
            typeDeclaration = TypeUtil.toJavaDeclaration(variable.getType(), this.caller.getTypeNames());
            this.content.codeln(0, typeDeclaration + " " + name + ";");
        }
        this.content.comment(1, 0, "Initial action code.");
        if (node.getInitAction() != null) {
            this.getStatementGenerator().generateForInit(node.getInitAction());
        }
        this.content.codeln(0, "return me;");
        this.content.endMethod("createInitialConfiguration");
    }

    protected void generateBehaviorToString(NodeDecl node) {
        Object name;
        String name2;
        String processName;
        Object process;
        String configurationName = ProgramGenerator.getConfigurationName(node);
        this.getDependencyManager().getShortName("obp.explorer.runtime.BehaviorConfiguration");
        this.content.beginMethod(4, "String", "toStringConfiguration", null, new Java.Parameter[]{new Java.Parameter(0, "BehaviorConfiguration", "behaviorConfiguration")});
        this.content.codeln(0, configurationName + " me = (" + configurationName + ") behaviorConfiguration;");
        this.content.codeln(0, "StringBuilder text = new StringBuilder();");
        if (node instanceof ProcessDecl) {
            this.content.codeln(0, "text.append(\"proc: \");");
        } else {
            this.content.codeln(0, "text.append(\"component: \");");
        }
        this.content.codeln(0, "text.append(\"'\");");
        this.content.codeln(0, "text.append(name);");
        this.content.codeln(0, "text.append(\"' [\");");
        if (node instanceof ProcessDecl) {
            process = (ProcessDecl)node;
            processName = ProgramGenerator.getBehaviorName((NodeDecl)process);
            this.content.codeln(0, "switch (me.state) {");
            for (State state : ((ProcessDecl)process).getStateList()) {
                name2 = NameUtil.capName(state.getName());
                this.content.codeln(0, "case " + processName + "." + name2 + ": ");
                this.content.codeln(1, "text.append(\"@" + state.getName() + ",\");");
                this.content.codeln(1, "break;");
            }
            this.content.codeln(0, "}");
        }
        for (LocalVariable variable : node.getVarList()) {
            if (!this.isConfigurationVariable(variable)) continue;
            name = NameUtil.uncapName(variable.getName());
            this.content.codeln(0, "text.append(\"\\n\\t- " + variable.getName() + "=\");");
            this.content.codeln(0, "text.append(" + TypeUtil.generateToStringCode("me." + (String)name, variable.getType(), this.getDependencyManager()) + ");");
        }
        this.content.codeln(0, "text.append(\"\\n]\");");
        this.content.codeln(0, "return text.toString();");
        this.content.endMethod("toStringConfiguration");
        this.getDependencyManager().getShortName("obp.explorer.runtime.BehaviorConfiguration");
        this.content.beginMethod(4, "String", "toDotStringConfiguration", null, new Java.Parameter[]{new Java.Parameter(0, "BehaviorConfiguration", "behaviorConfiguration")});
        this.content.codeln(0, configurationName + " me = (" + configurationName + ") behaviorConfiguration;");
        this.content.codeln(0, "StringBuilder text = new StringBuilder();");
        this.content.codeln(0, "text.append(\"'\");");
        this.content.codeln(0, "text.append(name);");
        this.content.codeln(0, "text.append(\"' [\");");
        if (node instanceof ProcessDecl) {
            process = (ProcessDecl)node;
            processName = ProgramGenerator.getBehaviorName((NodeDecl)process);
            this.content.codeln(0, "switch (me.state) {");
            for (State state : ((ProcessDecl)process).getStateList()) {
                name2 = NameUtil.capName(state.getName());
                this.content.codeln(0, "case " + processName + "." + name2 + ": ");
                this.content.codeln(1, "text.append(\"@" + state.getName() + ",\");");
                this.content.codeln(1, "break;");
            }
            this.content.codeln(0, "}");
        }
        for (LocalVariable variable : node.getVarList()) {
            if (!this.isConfigurationVariable(variable)) continue;
            name = NameUtil.uncapName(variable.getName());
            this.content.codeln(0, "text.append(\" " + variable.getName() + "=\");");
            this.content.codeln(0, "text.append(" + TypeUtil.generateToStringCode("me." + (String)name, variable.getType(), this.getDependencyManager()) + ");");
        }
        this.content.codeln(0, "text.append(\"]\");");
        this.content.codeln(0, "return text.toString();");
        this.content.endMethod("toDotStringConfiguration");
    }

    protected String toJavaCode(MinBound bound) {
        FiniteBound finite = (FiniteBound)bound;
        return ", " + finite.getVal() + ", " + finite.isStrict();
    }

    protected String toJavaCode(MaxBound bound) {
        if (bound instanceof FiniteBound) {
            FiniteBound finite = (FiniteBound)bound;
            return ", " + finite.getVal() + ", " + finite.isStrict();
        }
        return "";
    }
}

