/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.checker;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import obp.fiacre.checker.ProgramAnalyzer;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.Instance;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.ModelWalker;
import obp.fiacre.model.NodeDecl;
import obp.fiacre.model.ParamPortDecl;
import obp.fiacre.model.PortDecl;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Profile;
import obp.fiacre.model.SingleAssignment;
import obp.fiacre.model.Statement;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Wait;
import obp.fiacre.util.CommentedUtil;
import obp.fiacre.util.ComponentUtil;
import obp.fiacre.util.ProcessUtil;

public class NodeAnalyzer {
    private final ProgramAnalyzer caller;
    private boolean valid = true;
    private final Map<String, Integer> informalMap = new LinkedHashMap<String, Integer>();
    private final Map<ProcessDecl, Set<String>> informalByProcessMap = new LinkedHashMap<ProcessDecl, Set<String>>();
    private final Map<PortDecl, int[]> connectedBehaviorsByChannelMap = new HashMap<PortDecl, int[]>();
    private final Map<PortDecl, ComponentDecl> channelByComponentMap = new HashMap<PortDecl, ComponentDecl>();
    private final Map<ProcessDecl, List<Wait>> waitByProcessMap = new HashMap<ProcessDecl, List<Wait>>();
    private final Map<Wait, String> waitNameMap = new LinkedHashMap<Wait, String>();
    private final Map<Wait, String> waitClockMap = new LinkedHashMap<Wait, String>();

    public NodeAnalyzer(ProgramAnalyzer caller) {
        this.caller = caller;
    }

    public boolean analyze() {
        for (Declaration declaration : this.caller.getProgram().getDeclarationList()) {
            if (declaration instanceof ProcessDecl) {
                this.checkProcess((ProcessDecl)declaration);
                continue;
            }
            if (!(declaration instanceof ComponentDecl)) continue;
            this.checkComponent((ComponentDecl)declaration);
        }
        for (Map.Entry entry : this.connectedBehaviorsByChannelMap.entrySet()) {
            int outputCount;
            PortDecl key = (PortDecl)entry.getKey();
            Profile profile = (Profile)key.getChannel();
            int[] value = (int[])entry.getValue();
            if (value[0] == 0) {
                if (this.channelByComponentMap.get(key) == null) continue;
                this.addError("Port '" + key.getName() + "' in component '" + this.channelByComponentMap.get(key).getName() + "' has no consumer.\n");
            }
            if ((outputCount = value[1]) == 0) {
                this.addWarning("Port '" + key.getName() + "' in component '" + this.channelByComponentMap.get(key).getName() + "' has no producer.\n");
                continue;
            }
            if (profile.getTypeCount() <= 0 || outputCount <= 1) continue;
            this.addError("Port '" + key.getName() + "' in component '" + this.channelByComponentMap.get(key).getName() + "' carries values and is synchronized by several outputs, it's not supported.\n");
        }
        return this.valid;
    }

    private void checkNode(final NodeDecl nodeDecl) {
        Statement initAction = nodeDecl.getInitAction();
        if (initAction != null) {
            initAction.accept(new ModelWalker(new ModelVisitor.Stub(){

                @Override
                public void visitSingleAssignment(SingleAssignment toVisit) {
                    VarRef ref;
                    if (toVisit.getLhs() instanceof VarRef && (ref = (VarRef)toVisit.getLhs()).getDecl() instanceof ArgumentVariable) {
                        NodeAnalyzer.this.addError("Forbidden assignment of shared variable '" + ref.getDecl().getName() + "' in node '" + nodeDecl.getName() + "'.\n");
                    }
                }
            }));
        }
    }

    private void checkComponent(ComponentDecl componentDecl) {
        this.checkNode(componentDecl);
        List<Instance> instanceList = ComponentUtil.getInstances(componentDecl);
        for (Instance instance : instanceList) {
            NodeDecl type = instance.getType();
            if (instance.getPortCount() != type.getPortCount()) {
                this.addError("In component '" + componentDecl.getName() + "', instanciation of '" + type.getName() + "' with " + instance.getPortCount() + " port parameters, but it needs " + type.getPortCount() + ".\n");
            }
            for (int i = 0; i < instance.getPortCount(); ++i) {
                PortDecl instancePort = instance.getPort(i);
                ParamPortDecl typePort = type.getPort(i);
                if (typePort.isIn() && !instancePort.isIn()) {
                    this.addError("In component '" + componentDecl.getName() + "', instanciation of '" + type.getName() + "': Port '" + instancePort.getName() + "' isn't in.\n");
                }
                if (!typePort.isOut() || instancePort.isOut()) continue;
                this.addError("In component '" + componentDecl.getName() + "', instanciation of '" + type.getName() + "': Port '" + instancePort.getName() + "' isn't out.\n");
            }
            boolean leaf = type instanceof ProcessDecl;
            for (int i = 0; i < instance.getPortCount(); ++i) {
                PortDecl instancePort = instance.getPort(i);
                ParamPortDecl typePort = type.getPort(i);
                if (leaf) {
                    if (typePort.isIn()) {
                        this.addInputForPort(instancePort);
                    }
                    if (!typePort.isOut()) continue;
                    this.addOutputForPort(instancePort);
                    continue;
                }
                this.addPortCountForPort(typePort, instancePort);
            }
        }
        for (PortDecl portDecl : componentDecl.getPortList()) {
            if (!this.connectedBehaviorsByChannelMap.containsKey(portDecl)) {
                this.addError("In component '" + componentDecl.getName() + "', port '" + portDecl.getName() + "' isn't used.\n");
            }
            this.channelByComponentMap.put(portDecl, componentDecl);
        }
        for (PortDecl portDecl : componentDecl.getLocalPortList()) {
            if (!this.connectedBehaviorsByChannelMap.containsKey(portDecl)) {
                this.addError("In component '" + componentDecl.getName() + "', port '" + portDecl.getName() + "' isn't used.\n");
            }
            this.channelByComponentMap.put(portDecl, componentDecl);
        }
    }

    public int[] getConnectedBehaviorCount(PortDecl port) {
        int[] count = this.connectedBehaviorsByChannelMap.get(port);
        if (count == null) {
            count = new int[]{0, 0};
            this.connectedBehaviorsByChannelMap.put(port, count);
        }
        return count;
    }

    private void addInputForPort(PortDecl port) {
        int[] count = this.getConnectedBehaviorCount(port);
        count[0] = count[0] + 1;
    }

    private void addOutputForPort(PortDecl port) {
        int[] count = this.getConnectedBehaviorCount(port);
        count[1] = count[1] + 1;
    }

    private void addPortCountForPort(PortDecl source, PortDecl target) {
        int[] sourceCount = this.getConnectedBehaviorCount(source);
        int[] targetCount = this.getConnectedBehaviorCount(target);
        targetCount[0] = targetCount[0] + sourceCount[0];
        targetCount[1] = targetCount[1] + sourceCount[1];
    }

    private void checkProcess(ProcessDecl processDecl) {
        this.checkNode(processDecl);
        for (ParamPortDecl paramPortDecl : processDecl.getPortList()) {
            if (!paramPortDecl.isIn() || !paramPortDecl.isOut()) continue;
            this.addError("Port '" + paramPortDecl.getName() + "' in process '" + processDecl.getName() + "' is declared in and out.\n");
        }
        Set<String> processInformalSet = CommentedUtil.collectAllInformals(processDecl);
        this.informalByProcessMap.put(processDecl, processInformalSet);
        for (String informal : processInformalSet) {
            if (this.informalMap.get(informal) != null) continue;
            this.informalMap.put(informal, this.informalMap.size());
        }
        List<Wait> list = ProcessUtil.findAll(Wait.class, processDecl);
        this.waitByProcessMap.put(processDecl, list);
        int current = 0;
        for (Wait wait : list) {
            this.waitNameMap.put(wait, "wait" + current);
            this.waitClockMap.put(wait, "clock" + current);
            ++current;
        }
    }

    public Map<String, Integer> getInformalMap() {
        return this.informalMap;
    }

    public Set<String> getInformalsForProcess(NodeDecl node) {
        Set<String> set = this.informalByProcessMap.get(node);
        if (set == null) {
            set = Collections.emptySet();
        }
        return set;
    }

    public List<Wait> getProcessWaitList(ProcessDecl processDecl) {
        return this.waitByProcessMap.get(processDecl);
    }

    public Map<Wait, String> getWaitNameMap() {
        return this.waitNameMap;
    }

    public Map<Wait, String> getWaitClockMap() {
        return this.waitClockMap;
    }

    private void addWarning(String message) {
        this.caller.getErrorHandler().handleError(1, message);
    }

    private void addError(String message) {
        this.valid = false;
        this.caller.getErrorHandler().handleError(2, message);
    }
}

