/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javabdd;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import jdd.bdd.Permutation;
import jdd.util.Configuration;
import jdd.util.Options;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDBitVector;
import net.sf.javabdd.BDDDomain;
import net.sf.javabdd.BDDException;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.BDDPairing;

public class JDDFactory
extends BDDFactory {
    private final jdd.bdd.BDD bdd;
    private int[] vars;
    private int[] level2var;
    private int[] var2level;
    public static final String REVISION = "$Revision: 1.5 $";

    private JDDFactory(int nodenum, int cachesize) {
        this.bdd = new jdd.bdd.BDD(nodenum, cachesize);
        this.vars = new int[256];
        Options.verbose = true;
    }

    public static BDDFactory init(int nodenum, int cachesize) {
        JDDFactory f = new JDDFactory(nodenum, cachesize);
        return f;
    }

    public BDD zero() {
        return new bdd(this.bdd.getZero());
    }

    public BDD one() {
        return new bdd(this.bdd.getOne());
    }

    protected void initialize(int nodenum, int cachesize) {
        throw new BDDException();
    }

    public boolean isInitialized() {
        return true;
    }

    public void done() {
        this.bdd.cleanup();
    }

    public void setError(int code) {
    }

    public void clearError() {
    }

    public int setMaxNodeNum(int size) {
        return 0;
    }

    public double setMinFreeNodes(double x) {
        int old = Configuration.minFreeNodesProcent;
        Configuration.minFreeNodesProcent = (int)(x * 100.0);
        return (double)old / 100.0;
    }

    public double setIncreaseFactor(double x) {
        return 0.0;
    }

    public int setMaxIncrease(int x) {
        int old = Configuration.maxNodeIncrease;
        Configuration.maxNodeIncrease = x;
        return old;
    }

    public int setNodeTableSize(int x) {
        return this.getNodeTableSize();
    }

    public int setCacheSize(int x) {
        return 0;
    }

    public int getCacheSize() {
        throw new UnsupportedOperationException();
    }

    public double setCacheRatio(double x) {
        return 0.0;
    }

    public int varNum() {
        return this.bdd.numberOfVariables();
    }

    public int setVarNum(int num) {
        int oldSize;
        int newSize;
        if (num > 0x3FFFFFFF) {
            throw new BDDException();
        }
        int old = this.bdd.numberOfVariables();
        for (newSize = oldSize = this.vars.length; num > newSize; newSize *= 2) {
        }
        if (oldSize != newSize) {
            int[] oldVars = this.vars;
            this.vars = new int[newSize];
            System.arraycopy(oldVars, 0, this.vars, 0, old);
            if (this.level2var != null) {
                int[] oldlevel2var = this.level2var;
                this.level2var = new int[newSize];
                System.arraycopy(oldlevel2var, 0, this.level2var, 0, old);
                int[] oldvar2level = this.var2level;
                this.var2level = new int[newSize];
                System.arraycopy(oldvar2level, 0, this.var2level, 0, old);
            }
        }
        while (this.bdd.numberOfVariables() < num) {
            int k = this.bdd.numberOfVariables();
            this.vars[k] = this.bdd.createVar();
            this.bdd.ref(this.vars[k]);
            if (this.level2var == null) continue;
            this.level2var[k] = k;
            this.var2level[k] = k;
        }
        return old;
    }

    public int duplicateVar(int var) {
        throw new UnsupportedOperationException();
    }

    public BDD ithVar(int var) {
        if (var >= this.bdd.numberOfVariables()) {
            throw new BDDException();
        }
        int v = var;
        return new bdd(this.vars[v]);
    }

    public BDD nithVar(int var) {
        if (var >= this.bdd.numberOfVariables()) {
            throw new BDDException();
        }
        int v = var;
        return new bdd(this.bdd.not(this.vars[v]));
    }

    public void printAll() {
        throw new BDDException();
    }

    public void printTable(BDD b) {
        throw new BDDException();
    }

    public int level2Var(int level) {
        return this.level2var != null ? this.level2var[level] : level;
    }

    public int var2Level(int var) {
        return this.var2level != null ? this.var2level[var] : var;
    }

    public void reorder(BDDFactory.ReorderMethod m) {
        throw new BDDException();
    }

    public void autoReorder(BDDFactory.ReorderMethod method) {
        throw new BDDException();
    }

    public void autoReorder(BDDFactory.ReorderMethod method, int max) {
        throw new BDDException();
    }

    public BDDFactory.ReorderMethod getReorderMethod() {
        throw new BDDException();
    }

    public int getReorderTimes() {
        throw new BDDException();
    }

    public void disableReorder() {
        throw new BDDException();
    }

    public void enableReorder() {
        throw new BDDException();
    }

    public int reorderVerbose(int v) {
        throw new BDDException();
    }

    public void setVarOrder(int[] neworder) {
        int i;
        if (this.var2level != null) {
            throw new BDDException();
        }
        if (this.bdd.numberOfVariables() != neworder.length) {
            throw new BDDException();
        }
        int[] newvars = new int[this.vars.length];
        this.var2level = new int[this.vars.length];
        this.level2var = new int[this.vars.length];
        for (i = 0; i < this.bdd.numberOfVariables(); ++i) {
            int k = neworder[i];
            newvars[k] = this.vars[i];
            this.var2level[k] = i;
            this.level2var[i] = k;
        }
        this.vars = newvars;
        for (i = 0; i < this.numberOfDomains(); ++i) {
            BDDDomain d = this.getDomain(i);
            d.var = this.makeSet(d.ivar);
        }
    }

    public void addVarBlock(BDD var, boolean fixed) {
        throw new BDDException();
    }

    public void addVarBlock(int first, int last, boolean fixed) {
        throw new BDDException();
    }

    public void varBlockAll() {
        throw new BDDException();
    }

    public void clearVarBlocks() {
        throw new BDDException();
    }

    public void printOrder() {
        throw new BDDException();
    }

    public int nodeCount(Collection r) {
        throw new BDDException();
    }

    public int getNodeTableSize() {
        return this.bdd.countRootNodes();
    }

    public int getNodeNum() {
        return this.bdd.countRootNodes();
    }

    public int reorderGain() {
        throw new BDDException();
    }

    public void printStat() {
        this.bdd.showStats();
    }

    public BDDPairing makePair() {
        return new bddPairing();
    }

    public void swapVar(int v1, int v2) {
        throw new BDDException();
    }

    protected BDDDomain createDomain(int a, BigInteger b) {
        return new bddDomain(a, b);
    }

    protected BDDBitVector createBitVector(int a) {
        return new bddBitVector(a);
    }

    public String getVersion() {
        return "JDD " + REVISION.substring(11, REVISION.length() - 2);
    }

    private class bddBitVector
    extends BDDBitVector {
        private bddBitVector(int a) {
            super(a);
        }

        public BDDFactory getFactory() {
            return JDDFactory.this;
        }
    }

    private class bddDomain
    extends BDDDomain {
        private bddDomain(int a, BigInteger b) {
            super(a, b);
        }

        public BDDFactory getFactory() {
            return JDDFactory.this;
        }
    }

    private class bddPairing
    extends BDDPairing {
        private int[] from;
        private int[] to;
        private Permutation pairing;

        private bddPairing() {
            this.reset();
        }

        public void set(int oldvar, int newvar) {
            for (int i = 0; i < this.from.length; ++i) {
                if (this.from[i] != JDDFactory.this.vars[oldvar]) continue;
                this.to[i] = JDDFactory.this.vars[newvar];
                this.pairing = JDDFactory.this.bdd.createPermutation(this.from, this.to);
                return;
            }
            int[] oldfrom = this.from;
            this.from = new int[this.from.length + 1];
            System.arraycopy(oldfrom, 0, this.from, 0, oldfrom.length);
            this.from[oldfrom.length] = JDDFactory.this.vars[oldvar];
            int[] oldto = this.to;
            this.to = new int[this.to.length + 1];
            System.arraycopy(oldto, 0, this.to, 0, oldto.length);
            this.to[oldto.length] = JDDFactory.this.vars[newvar];
            this.pairing = JDDFactory.this.bdd.createPermutation(this.from, this.to);
        }

        public void set(int oldvar, BDD newvar) {
            throw new BDDException();
        }

        public void set(int[] oldvar, int[] newvar) {
            int[] oldfrom = this.from;
            this.from = new int[this.from.length + oldvar.length];
            System.arraycopy(oldfrom, 0, this.from, 0, oldfrom.length);
            for (int i = 0; i < oldvar.length; ++i) {
                this.from[i + oldfrom.length] = JDDFactory.this.vars[oldvar[i]];
            }
            int[] oldto = this.to;
            this.to = new int[this.to.length + newvar.length];
            System.arraycopy(oldto, 0, this.to, 0, oldto.length);
            for (int i = 0; i < newvar.length; ++i) {
                this.to[i + oldto.length] = JDDFactory.this.vars[newvar[i]];
            }
            this.pairing = JDDFactory.this.bdd.createPermutation(this.from, this.to);
        }

        void debug() {
            for (int i = 0; i < this.from.length; ++i) {
                System.out.println(JDDFactory.this.bdd.getVar(this.from[i]) + " -> " + JDDFactory.this.bdd.getVar(this.to[i]));
            }
        }

        public void reset() {
            this.to = new int[0];
            this.from = this.to;
            this.pairing = null;
        }
    }

    private class bdd
    extends BDD {
        int _index;
        static final int INVALID_BDD = -1;
        static final boolean USE_FINALIZER = false;

        bdd(int index) {
            this._index = index;
            JDDFactory.this.bdd.ref(this._index);
        }

        public BDDFactory getFactory() {
            return JDDFactory.this;
        }

        public boolean isZero() {
            return this._index == JDDFactory.this.bdd.getZero();
        }

        public boolean isOne() {
            return this._index == JDDFactory.this.bdd.getOne();
        }

        public int var() {
            int v = JDDFactory.this.bdd.getVar(this._index);
            return JDDFactory.this.level2var != null ? JDDFactory.this.level2var[v] : v;
        }

        public int level() {
            int v = JDDFactory.this.bdd.getVar(this._index);
            return v;
        }

        public BDD high() {
            return new bdd(JDDFactory.this.bdd.getHigh(this._index));
        }

        public BDD low() {
            return new bdd(JDDFactory.this.bdd.getLow(this._index));
        }

        public BDD id() {
            return new bdd(this._index);
        }

        public BDD not() {
            return new bdd(JDDFactory.this.bdd.not(this._index));
        }

        public BDD ite(BDD thenBDD, BDD elseBDD) {
            int x = this._index;
            int y = ((bdd)thenBDD)._index;
            int z = ((bdd)elseBDD)._index;
            return new bdd(JDDFactory.this.bdd.ite(x, y, z));
        }

        public BDD relprod(BDD that, BDD var) {
            int x = this._index;
            int y = ((bdd)that)._index;
            int z = ((bdd)var)._index;
            return new bdd(JDDFactory.this.bdd.relProd(x, y, z));
        }

        public BDD compose(BDD g, int var) {
            int x = this._index;
            int y = ((bdd)g)._index;
            return null;
        }

        public BDD veccompose(BDDPairing pair) {
            int x = this._index;
            return null;
        }

        public BDD constrain(BDD that) {
            int x = this._index;
            int y = ((bdd)that)._index;
            return null;
        }

        public BDD exist(BDD var) {
            int x = this._index;
            int y = ((bdd)var)._index;
            return new bdd(JDDFactory.this.bdd.exists(x, y));
        }

        public BDD forAll(BDD var) {
            int x = this._index;
            int y = ((bdd)var)._index;
            return new bdd(JDDFactory.this.bdd.forall(x, y));
        }

        public BDD unique(BDD var) {
            int x = this._index;
            int y = ((bdd)var)._index;
            return null;
        }

        public BDD restrict(BDD var) {
            int x = this._index;
            int y = ((bdd)var)._index;
            return new bdd(JDDFactory.this.bdd.restrict(x, y));
        }

        public BDD restrictWith(BDD that) {
            int x = this._index;
            int y = ((bdd)that)._index;
            int a = JDDFactory.this.bdd.restrict(x, y);
            JDDFactory.this.bdd.deref(x);
            if (this != that) {
                that.free();
            }
            JDDFactory.this.bdd.deref(a);
            this._index = a;
            return this;
        }

        public BDD simplify(BDD d) {
            int x = this._index;
            int y = ((bdd)d)._index;
            return new bdd(JDDFactory.this.bdd.simplify(x, y));
        }

        public BDD support() {
            int x = this._index;
            return new bdd(JDDFactory.this.bdd.support(x));
        }

        /*
         * WARNING - void declaration
         */
        private int apply0(int x, int y, int z) {
            void var4_4;
            switch (z) {
                case 0: {
                    int r = JDDFactory.this.bdd.and(x, y);
                    break;
                }
                case 1: {
                    int r = JDDFactory.this.bdd.xor(x, y);
                    break;
                }
                case 2: {
                    int r = JDDFactory.this.bdd.or(x, y);
                    break;
                }
                case 3: {
                    int r = JDDFactory.this.bdd.nand(x, y);
                    break;
                }
                case 4: {
                    int r = JDDFactory.this.bdd.nor(x, y);
                    break;
                }
                case 5: {
                    int r = JDDFactory.this.bdd.imp(x, y);
                    break;
                }
                case 6: {
                    int r = JDDFactory.this.bdd.biimp(x, y);
                    break;
                }
                case 7: {
                    int r = JDDFactory.this.bdd.and(x, JDDFactory.this.bdd.not(y));
                    break;
                }
                default: {
                    throw new BDDException();
                }
            }
            return (int)var4_4;
        }

        public BDD apply(BDD that, BDDFactory.BDDOp opr) {
            int x = this._index;
            int y = ((bdd)that)._index;
            int z = opr.id;
            return new bdd(this.apply0(x, y, z));
        }

        public BDD applyWith(BDD that, BDDFactory.BDDOp opr) {
            int x = this._index;
            int y = ((bdd)that)._index;
            int z = opr.id;
            int a = this.apply0(x, y, z);
            JDDFactory.this.bdd.deref(x);
            if (this != that) {
                that.free();
            }
            JDDFactory.this.bdd.ref(a);
            this._index = a;
            return this;
        }

        public BDD applyAll(BDD that, BDDFactory.BDDOp opr, BDD var) {
            int x = this._index;
            int y = ((bdd)that)._index;
            int z = opr.id;
            int a = ((bdd)var)._index;
            int r = this.apply0(x, y, z);
            JDDFactory.this.bdd.ref(r);
            int r2 = JDDFactory.this.bdd.forall(r, a);
            JDDFactory.this.bdd.deref(r);
            return new bdd(r2);
        }

        public BDD applyEx(BDD that, BDDFactory.BDDOp opr, BDD var) {
            int x = this._index;
            int y = ((bdd)that)._index;
            int z = opr.id;
            int a = ((bdd)var)._index;
            int r = this.apply0(x, y, z);
            JDDFactory.this.bdd.ref(r);
            int r2 = JDDFactory.this.bdd.exists(r, a);
            JDDFactory.this.bdd.deref(r);
            return new bdd(r2);
        }

        public BDD applyUni(BDD that, BDDFactory.BDDOp opr, BDD var) {
            int x = this._index;
            int y = ((bdd)that)._index;
            int z = opr.id;
            int a = ((bdd)var)._index;
            throw new BDDException();
        }

        public BDD satOne() {
            int x = this._index;
            return new bdd(JDDFactory.this.bdd.oneSat(x));
        }

        public BDD replace(BDDPairing pair) {
            int x = this._index;
            return new bdd(JDDFactory.this.bdd.replace(x, ((bddPairing)pair).pairing));
        }

        public BDD replaceWith(BDDPairing pair) {
            int x = this._index;
            int y = JDDFactory.this.bdd.replace(x, ((bddPairing)pair).pairing);
            JDDFactory.this.bdd.deref(x);
            JDDFactory.this.bdd.ref(y);
            this._index = y;
            return this;
        }

        public int nodeCount() {
            return JDDFactory.this.bdd.nodeCount(this._index);
        }

        public double satCount() {
            return JDDFactory.this.bdd.satCount(this._index);
        }

        public boolean equals(BDD that) {
            return this._index == ((bdd)that)._index;
        }

        public int hashCode() {
            return this._index;
        }

        public void free() {
            JDDFactory.this.bdd.deref(this._index);
            this._index = -1;
        }

        public BDD fullSatOne() {
            throw new BDDException();
        }

        public BDD satOne(BDD var, boolean pol) {
            throw new UnsupportedOperationException();
        }

        public List allsat() {
            throw new BDDException();
        }

        public double pathCount() {
            throw new BDDException();
        }

        public int[] varProfile() {
            throw new BDDException();
        }
    }
}

