/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.data.types.complex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.data.constants.EnumLiteral;
import obp.if2.data.types.complex.CollectionType;

public class EnumerationType
extends CollectionType {
    private final List<EnumLiteral> literalsList = new ArrayList<EnumLiteral>();

    public List<EnumLiteral> getLiteralsList() {
        return Collections.unmodifiableList(this.literalsList);
    }

    public int getLiteralsCount() {
        return this.literalsList.size();
    }

    public EnumLiteral getLiterals(int index) {
        if (index < 0 || index >= this.getLiteralsCount()) {
            return null;
        }
        return this.literalsList.get(index);
    }

    public void addLiterals(EnumLiteral newValue) {
        this.addLiterals(this.getLiteralsCount(), newValue);
    }

    public void addLiterals(int index, EnumLiteral newValue) {
        this.literalsList.add(index, newValue);
    }

    public EnumLiteral setLiterals(int index, EnumLiteral newValue) {
        return this.literalsList.set(index, newValue);
    }

    public void addAllLiterals(Collection<EnumLiteral> toAddList) {
        for (EnumLiteral newValue : toAddList) {
            this.addLiterals(this.getLiteralsCount(), newValue);
        }
    }

    public void removeLiterals(EnumLiteral value) {
        int index = this.literalsList.indexOf(value);
        if (index >= 0) {
            this.removeLiterals(index);
        }
    }

    public void removeLiterals(int index) {
        this.literalsList.remove(index);
    }

    @Override
    public void accept(If2Visitor visitor) {
        visitor.visitEnumerationType(this);
    }
}

