/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.state_event.diagnosis.dsl.parsing;

import java.text.ParseException;
import java.util.function.Consumer;
import obp2.language.state_event.diagnosis.dsl.grammar.SEDiagLexer;
import obp2.language.state_event.diagnosis.dsl.grammar.SEDiagParser;
import obp2.language.state_event.diagnosis.dsl.model.DiagnosisExp;
import obp2.language.state_event.diagnosis.dsl.model.Type;
import obp2.language.state_event.diagnosis.dsl.parsing.ModelBuilder;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class SEDiagnosisParser {
    private static SEDiagnosisParser instance = new SEDiagnosisParser();

    public static DiagnosisExp parse(String expression, Consumer<Exception> errorHandler) {
        ANTLRInputStream is = new ANTLRInputStream(expression);
        return instance.parse(is, DiagnosisExp.class, errorHandler);
    }

    public <T extends DiagnosisExp> T parse(ANTLRInputStream is, Class<T> type) {
        try {
            return this.parse(is, type, e -> {});
        }
        catch (Error e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public <T extends DiagnosisExp> T parse(ANTLRInputStream is, Class<T> type, final Consumer<Exception> errorHandler) {
        SEDiagLexer lexer = new SEDiagLexer((CharStream)is);
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                errorHandler.accept(new ParseException(msg, charPositionInLine));
            }
        });
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SEDiagParser parser = new SEDiagParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy(){

            public void reportError(Parser recognizer, RecognitionException e) {
                errorHandler.accept(e);
            }
        });
        SEDiagParser.ExpressionContext tree = parser.expression();
        ModelBuilder builder = new ModelBuilder();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)builder, (ParseTree)tree);
        DiagnosisExp result = (DiagnosisExp)builder.getValue((ParseTree)tree, type);
        if (result.getType() != Type.BOOLEAN) {
            throw new RuntimeException("Diagnosis expression should have a boolean return type");
        }
        return (T)result;
    }
}

