/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xid.basics.model.AddObjectChangeMark;
import org.xid.basics.model.AttributeChangeMark;
import org.xid.basics.model.ChangeMark;
import org.xid.basics.model.ChangeRecorder;
import org.xid.basics.model.ModelObject;
import org.xid.basics.model.PutObjectChangeMark;
import org.xid.basics.model.RemoveObjectChangeMark;

public class ModelChangeRecorder
implements ChangeRecorder {
    protected final Stack<ChangeMark> pastChanges = new Stack();
    protected final Stack<ChangeMark> futureChanges = new Stack();
    protected long currentTimestamp = 0L;
    protected boolean recording = false;
    protected boolean undoing = false;

    protected void mark(ChangeMark mark) {
        if (!this.recording) {
            return;
        }
        if (this.isUndoing()) {
            this.futureChanges.add(mark);
        } else {
            if (this.pastChanges.isEmpty() && !mark.isOperationMark()) {
                this.newOperation();
            }
            this.pastChanges.add(mark);
        }
    }

    public void noRecord() {
        this.recording = false;
    }

    @Override
    public void newOperation() {
        this.recording = true;
        this.clearFuture();
        if (!this.pastChanges.isEmpty() && ((ChangeMark)this.pastChanges.lastElement()).isOperationMark()) {
            return;
        }
        ++this.currentTimestamp;
        this.mark(ChangeMark.Operation(this.currentTimestamp));
    }

    protected void clearFuture() {
        this.futureChanges.clear();
    }

    @Override
    public void recordChangeAttribute(ModelObject receiver, String attributeName, Object oldValue) {
        this.mark(new AttributeChangeMark(this.currentTimestamp, receiver, attributeName, oldValue));
    }

    @Override
    public void recordAddObject(ModelObject receiver, String attributeName, int index) {
        this.mark(new AddObjectChangeMark(this.currentTimestamp, receiver, attributeName, index));
    }

    @Override
    public void recordRemoveObject(ModelObject receiver, String attributeName, int index, Object removedObject) {
        this.mark(new RemoveObjectChangeMark(this.currentTimestamp, receiver, attributeName, index, removedObject));
    }

    @Override
    public void recordPutObject(ModelObject receiver, String attributeName, Object index, Object oldValue) {
        this.mark(new PutObjectChangeMark(this.currentTimestamp, receiver, attributeName, index, oldValue));
    }

    @Override
    public void recordRemoveObject(ModelObject receiver, String attributeName, Object index, Object removedObject) {
        this.mark(new RemoveObjectChangeMark(this.currentTimestamp, receiver, attributeName, index, removedObject));
    }

    protected List<ChangeMark> getChangesToUndo() {
        ArrayList<ChangeMark> result = new ArrayList<ChangeMark>();
        while (!this.pastChanges.peek().isOperationMark() && !this.pastChanges.isEmpty()) {
            result.add(this.pastChanges.pop());
        }
        result.add(0, this.pastChanges.pop());
        return result;
    }

    @Override
    public void removePendingOperationMark() {
        if (this.pastChanges.isEmpty()) {
            return;
        }
        int lastIndex = this.pastChanges.size() - 1;
        if (((ChangeMark)this.pastChanges.get(lastIndex)).isOperationMark()) {
            this.pastChanges.remove(lastIndex);
        }
    }

    @Override
    public void undo() {
        this.undoing = true;
        for (ChangeMark oneChange : this.getChangesToUndo()) {
            if (oneChange.isOperationMark()) {
                this.currentTimestamp = oneChange.getTimestamp();
                this.futureChanges.add(oneChange);
            }
            oneChange.undo();
        }
        --this.currentTimestamp;
        this.undoing = false;
    }

    @Override
    public boolean canUndo() {
        return !this.pastChanges.isEmpty();
    }

    protected List<ChangeMark> getChangesToRedo() {
        ArrayList<ChangeMark> result = new ArrayList<ChangeMark>();
        while (!this.futureChanges.peek().isOperationMark() && !this.futureChanges.isEmpty()) {
            result.add(this.futureChanges.pop());
        }
        result.add(0, this.futureChanges.pop());
        return result;
    }

    @Override
    public void redo() {
        for (ChangeMark oneChange : this.getChangesToRedo()) {
            if (oneChange.isOperationMark()) {
                this.currentTimestamp = oneChange.getTimestamp();
                this.pastChanges.add(oneChange);
            }
            oneChange.undo();
        }
        ++this.currentTimestamp;
    }

    @Override
    public boolean canRedo() {
        return !this.futureChanges.isEmpty();
    }

    protected boolean isUndoing() {
        return this.undoing;
    }

    @Override
    public long getTimestamp() {
        return this.currentTimestamp;
    }
}

