/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import obp.explorer.runtime.core.Transition;
import obp.simulation.observer.TransitionObservable;
import obp.simulation.observer.TransitionObserver;

public class TransitionModel
implements TransitionObservable {
    private List<TransitionObserver> observers = new ArrayList<TransitionObserver>();
    protected List<Transition> transitions = new ArrayList<Transition>();

    public List<Transition> getTransitions() {
        return this.transitions;
    }

    public void clear() {
        this.transitions.clear();
        this.notifyObserver(this.transitions);
    }

    public void newTransitions(List<Transition> newTransitions) {
        this.transitions = newTransitions;
        this.notifyObserver(this.transitions);
    }

    public Transition getRandomTransition() {
        Random rand = new Random();
        if (this.transitions.size() > 0) {
            int randomIndex = rand.nextInt(this.transitions.size());
            return this.transitions.get(randomIndex);
        }
        return null;
    }

    @Override
    public void addObserver(TransitionObserver obs) {
        this.observers.add(obs);
    }

    @Override
    public void removeObserver() {
        this.observers = new ArrayList<TransitionObserver>();
    }

    @Override
    public void notifyObserver(List<Transition> transitions) {
        for (TransitionObserver obs : this.observers) {
            obs.update(transitions);
        }
    }
}

