/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.state_event;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.function.Function;
import obp2.language.state_event.StateEventRuntimeView;
import obp2.language.state_event.diagnosis.SEAtomicPropositionsEvaluator;
import obp2.language.state_event.model.StateEventDenseReader;
import obp2.language.state_event.model.StateEventModel;
import obp2.language.state_event.model.StateEventTransition;
import obp2.language.state_event.runtime.StateEventConfiguration;
import obp2.language.state_event.runtime.StateEventTransitionRelation;
import obp2.runtime.core.IAtomicPropositionsEvaluator;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ILanguagePlugin;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.ITreeProjector;
import obp2.runtime.core.LanguageModule;

public class StateEventPlugin
implements ILanguagePlugin<URI, StateEventConfiguration, StateEventTransition, Void> {
    public String[] getExtensions() {
        return new String[]{".sek"};
    }

    public Function<URI, ILanguageModule<StateEventConfiguration, StateEventTransition, Void>> languageModuleFunction() {
        return this::getModule;
    }

    public ILanguageModule<StateEventConfiguration, StateEventTransition, Void> getModule(URI explicitProgramURI) {
        return this.getModule(new File(explicitProgramURI));
    }

    public ILanguageModule<StateEventConfiguration, StateEventTransition, Void> getModule(String explicitProgramFileName) {
        return this.getModule(new File(explicitProgramFileName));
    }

    public ILanguageModule<StateEventConfiguration, StateEventTransition, Void> getModule(File programFile) {
        StateEventModel model = this.loadModel(programFile);
        StateEventTransitionRelation transitionRelation = new StateEventTransitionRelation(programFile.getName(), model);
        return new LanguageModule((ITransitionRelation)transitionRelation, (IAtomicPropositionsEvaluator)new SEAtomicPropositionsEvaluator(model), (ITreeProjector)new StateEventRuntimeView(transitionRelation));
    }

    public StateEventModel loadModel(File modelFile) {
        try {
            StateEventDenseReader reader = new StateEventDenseReader();
            return reader.read(modelFile);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public String getName() {
        return "StateEvent";
    }
}

