/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.bitstate;

import announce4j.Announcer;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import obp2.core.IConfiguration;
import obp2.core.IStateSpaceManager;
import obp2.core.execution.IExecutionController;
import obp2.core.execution.IExecutionMonitor;
import obp2.events.ExecutionEndedEvent;
import obp2.events.PropertyEvent;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ISimpleTransitionRelationIterator;
import obp2.runtime.core.ITransitionRelation;

public class BFS_BitState_DepthAware<C extends IConfiguration, A>
implements IExecutionController<C, A> {
    protected final Announcer announcer = new Announcer(true);
    protected final IExecutionMonitor.Simple monitor = new IExecutionMonitor.Simple();
    ILanguageModule<?, ?, ?> languageModule;
    ISimpleTransitionRelationIterator<byte[]> simpleTransitionRelation;
    protected final Function<byte[], Integer> hashLambda;
    protected final Map<String, BigInteger> metrics = new LinkedHashMap<String, BigInteger>();
    protected static final int defaultHashModulo = 300;
    protected static final long maxConfPerDepth = Math.round(90.0);
    protected BigInteger configurationCount;
    protected BigInteger stepCount;
    protected int currentDepth;
    protected HashMap<Integer, byte[]> currentDepthFrontier;
    protected HashMap<Integer, byte[]> nextDepthFrontier;

    public BFS_BitState_DepthAware(ITransitionRelation<Object, Object, Object> runtime, Function<byte[], Integer> hashLambda) {
        System.out.println("Running BFS BitState Depth Aware");
        this.hashLambda = hashLambda;
        this.languageModule = runtime.getModule();
        this.simpleTransitionRelation = this.languageModule.getSimpleByteArrayTransitionRelation();
        this.reset();
    }

    public BFS_BitState_DepthAware(ITransitionRelation<Object, Object, Object> runtime, IStateSpaceManager<C, A, Object> stateSpaceManager) {
        this(runtime, BFS_BitState_DepthAware::defaultHash);
    }

    private static int defaultHash(byte[] configuration) {
        return Arrays.hashCode(configuration) % 300;
    }

    public Announcer getAnnouncer() {
        return this.announcer;
    }

    public IStateSpaceManager<C, A, Object> getStateSpaceManager() {
        return null;
    }

    public BigInteger configurationCount() {
        return this.configurationCount;
    }

    public BigInteger stepCount() {
        return this.stepCount;
    }

    public ITransitionRelation<C, A, Object> getRuntime() {
        return null;
    }

    public IExecutionMonitor getMonitor() {
        return this.monitor;
    }

    protected void reset() {
        this.configurationCount = BigInteger.ZERO;
        this.stepCount = BigInteger.ZERO;
        this.currentDepth = 0;
        this.currentDepthFrontier = new LinkedHashMap<Integer, byte[]>();
        this.nextDepthFrontier = new LinkedHashMap<Integer, byte[]>();
    }

    protected RegisterResult registerConfiguration(byte[] configuration) {
        boolean result;
        this.stepCount = this.stepCount.add(BigInteger.ONE);
        int hash = this.hashLambda.apply(configuration);
        boolean bl = result = this.nextDepthFrontier.put(hash, configuration) == null;
        if (result) {
            this.configurationCount = this.configurationCount.add(BigInteger.ONE);
        }
        return (long)this.nextDepthFrontier.size() >= maxConfPerDepth ? RegisterResult.addedButCap : (result ? RegisterResult.added : RegisterResult.collision);
    }

    private int registerAllConfigurations(Iterable<byte[]> configurations) {
        int count = 0;
        for (byte[] configuration : configurations) {
            RegisterResult result = this.registerConfiguration(configuration);
            switch (result) {
                case added: {
                    ++count;
                    break;
                }
                case addedButCap: {
                    return count + 1;
                }
            }
        }
        return count;
    }

    private int registerAllConfigurations(Iterator<byte[]> configurationIterator) {
        int count = 0;
        while (configurationIterator.hasNext()) {
            RegisterResult result = this.registerConfiguration(configurationIterator.next());
            switch (result) {
                case added: {
                    ++count;
                    break;
                }
                case addedButCap: {
                    return count + 1;
                }
            }
        }
        return count;
    }

    protected void nextDepth() {
        HashMap<Integer, byte[]> oldFrontier = this.currentDepthFrontier;
        oldFrontier.clear();
        this.currentDepthFrontier = this.nextDepthFrontier;
        this.nextDepthFrontier = oldFrontier;
        ++this.currentDepth;
    }

    private void initialize() {
        this.reset();
        this.registerAllConfigurations(this.simpleTransitionRelation.initialIterator());
        this.nextDepth();
    }

    protected boolean checkAcceptation(byte[] configuration) {
        return this.simpleTransitionRelation.isAccepting((Object)configuration);
    }

    protected List<IConfiguration> counterExample(byte[] configuration) {
        IConfiguration original = (IConfiguration)this.languageModule.getMarshaller().deserializeConfiguration(configuration);
        return Collections.singletonList(original);
    }

    public void execute() {
        this.initialize();
        while (!this.currentDepthFrontier.isEmpty()) {
            int currentHash = (Integer)this.currentDepthFrontier.keySet().stream().findAny().get();
            byte[] currentConfiguration = this.currentDepthFrontier.remove(currentHash);
            if (this.checkAcceptation(currentConfiguration)) {
                this.announcer.announce((Object)new PropertyEvent((IExecutionController)this, false, "property", this.counterExample(currentConfiguration)));
                this.announcer.announce((Object)new ExecutionEndedEvent((IExecutionController)this));
                return;
            }
            Iterator targetIterator = this.simpleTransitionRelation.nextIterator((Object)currentConfiguration);
            int addedCount = this.registerAllConfigurations(targetIterator);
            if (!this.currentDepthFrontier.isEmpty() && (long)this.nextDepthFrontier.size() < maxConfPerDepth) continue;
            this.nextDepth();
        }
        this.announcer.announce((Object)new PropertyEvent((IExecutionController)this, true, "property", null));
        this.announcer.announce((Object)new ExecutionEndedEvent((IExecutionController)this));
    }

    protected void updateMetrics() {
        this.metrics.clear();
        this.metrics.put("confs", this.configurationCount);
        this.metrics.put("trans", this.stepCount);
        this.metrics.put("depth", BigInteger.valueOf(this.currentDepth));
    }

    public Map<String, BigInteger> metrics() {
        this.updateMetrics();
        return this.metrics;
    }

    protected static enum RegisterResult {
        added,
        collision,
        addedButCap;

    }
}

