/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.buchikripke.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import obp2.core.IBuchiConfiguration;
import obp2.core.IConfiguration;
import obp2.core.IFiredTransition;
import obp2.core.defaults.FiredTransition;
import obp2.language.buchikripke.runtime.KripkeBuchiConfiguration;
import obp2.language.buchikripke.runtime.KripkeBuchiLanguageModule;
import obp2.language.buchikripke.runtime.StutteringTransition;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.defaults.DefaultLanguageService;
import plug.utils.Pair;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;
import properties.PropositionalLogic.interpreter.atom.AtomArrayValuationEvaluator;

public class SE_KRIPKE_TBA_ProductSemantics
extends DefaultLanguageService<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>, Void>
implements ITransitionRelation<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>, Void> {
    boolean hasDeadlockAtomicProposition = false;
    boolean evaluateStutteringStep = true;

    public SE_KRIPKE_TBA_ProductSemantics(KripkeBuchiLanguageModule languageModule, boolean hasDeadlockAtomicProposition) {
        this.setModule((ILanguageModule)languageModule);
        this.hasDeadlockAtomicProposition = hasDeadlockAtomicProposition;
    }

    protected ITransitionRelation<IConfiguration, Object, ?> getKripkeTransitionRelation() {
        return ((KripkeBuchiLanguageModule)this.getModule()).kripke.getTransitionRelation();
    }

    protected ITransitionRelation<IBuchiConfiguration, GuardedTransition, ?> getBuchiTransitionRelation() {
        return ((KripkeBuchiLanguageModule)this.getModule()).buchi.getTransitionRelation();
    }

    public Set<KripkeBuchiConfiguration> initialConfigurations() {
        HashSet<KripkeBuchiConfiguration> result = new HashSet<KripkeBuchiConfiguration>();
        for (IConfiguration cKripke : this.getKripkeTransitionRelation().initialConfigurations()) {
            for (IBuchiConfiguration cBuchi : this.getBuchiTransitionRelation().initialConfigurations()) {
                KripkeBuchiConfiguration kbc = new KripkeBuchiConfiguration();
                kbc.kripke = cKripke;
                kbc.buchiState = cBuchi;
                result.add(kbc);
            }
        }
        return result;
    }

    public Collection<Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>> fireableTransitionsFrom(KripkeBuchiConfiguration source) {
        ArrayList<Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>> synchronousFireables = new ArrayList<Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>>();
        Collection kFireableTransitions = this.getKripkeTransitionRelation().fireableTransitionsFrom((Object)source.kripke);
        int numberOfFireableTransitions = kFireableTransitions.size();
        for (Object kripkeFireable : kFireableTransitions) {
            IFiredTransition kripkeTransition = this.getKripkeTransitionRelation().fireOneTransition((Object)source.kripke, kripkeFireable);
            if (kripkeTransition == null || kripkeTransition.getTargets() == null || kripkeTransition.getTargets().isEmpty()) {
                if (this.getKripkeTransitionRelation().hasBlockingTransitions()) {
                    --numberOfFireableTransitions;
                    continue;
                }
                throw new RuntimeException("The runtime " + this.getKripkeTransitionRelation() + " does not have blocking transitions, yet it didn't produce a target when firing " + kripkeFireable + " in " + source.kripke);
            }
            this.getKripkeBuchiSynchronousTransitions(source, kripkeTransition, synchronousFireables);
        }
        if (numberOfFireableTransitions == 0) {
            this.getKripkeBuchiSynchronousTransitions(source, StutteringTransition.instance, synchronousFireables);
        }
        return synchronousFireables;
    }

    public IFiredTransition<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>, Void> fireOneTransition(KripkeBuchiConfiguration source, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition> transition) {
        KripkeBuchiConfiguration myNewState = source.createCopy();
        myNewState.kripke = (IConfiguration)((IFiredTransition)transition.a).getTargets().iterator().next();
        IFiredTransition buchiTransition = this.getBuchiTransitionRelation().fireOneTransition((Object)source.buchiState, transition.b);
        myNewState.buchiState = (IBuchiConfiguration)buchiTransition.getTarget(0);
        return new FiredTransition((Object)source, (Object)myNewState, transition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getKripkeBuchiSynchronousTransitions(KripkeBuchiConfiguration source, Object kripkeFiredTransition, Collection<Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>> outFireables) {
        Collection<Object> kripkeTargets;
        Object kripkeFireable = null;
        Object kripkePayload = null;
        boolean isDeadlock = false;
        if (kripkeFiredTransition == StutteringTransition.instance) {
            kripkeFireable = kripkeFiredTransition;
            kripkePayload = new byte[]{};
            kripkeTargets = Collections.singleton(source.kripke);
            isDeadlock = true;
        } else {
            IFiredTransition transition = (IFiredTransition)kripkeFiredTransition;
            kripkeFireable = transition.getAction();
            kripkePayload = transition.getPayload();
            kripkeTargets = transition.getTargets();
        }
        for (IConfiguration iConfiguration : kripkeTargets) {
            AtomArrayValuationEvaluator atomArrayValuationEvaluator = ((KripkeBuchiLanguageModule)this.getModule()).apValuationEvaluator;
            synchronized (atomArrayValuationEvaluator) {
                boolean[] valuation;
                if (!isDeadlock) {
                    valuation = this.getValuation(source, kripkeFireable == kripkeFiredTransition ? null : kripkeFireable, kripkePayload, iConfiguration);
                    if (!this.hasDeadlockAP()) {
                        ((KripkeBuchiLanguageModule)this.getModule()).apValuationEvaluator.setValuation(valuation);
                    } else {
                        boolean[] v = new boolean[valuation.length + 1];
                        v[0] = false;
                        System.arraycopy(valuation, 0, v, 1, valuation.length);
                        ((KripkeBuchiLanguageModule)this.getModule()).apValuationEvaluator.setValuation(v);
                    }
                } else if (this.evaluateStutteringStep) {
                    valuation = this.getValuation(source, null, null, iConfiguration);
                    if (!this.hasDeadlockAP()) {
                        ((KripkeBuchiLanguageModule)this.getModule()).apValuationEvaluator.setValuation(valuation);
                    } else {
                        boolean[] v = new boolean[valuation.length + 1];
                        v[0] = true;
                        System.arraycopy(valuation, 0, v, 1, valuation.length);
                        ((KripkeBuchiLanguageModule)this.getModule()).apValuationEvaluator.setValuation(v);
                    }
                } else {
                    valuation = new boolean[((KripkeBuchiLanguageModule)this.getModule()).apValuationEvaluator.atomicPropositions.size()];
                    if (this.hasDeadlockAP()) {
                        valuation[0] = true;
                    }
                    ((KripkeBuchiLanguageModule)this.getModule()).apValuationEvaluator.setValuation(valuation);
                }
                Collection buchiTransitions = this.getBuchiTransitionRelation().fireableTransitionsFrom((Object)source.buchiState);
                int currentPriority = Integer.MIN_VALUE;
                boolean hasFireableAtCurrentPriority = false;
                for (GuardedTransition buchiTransition : buchiTransitions) {
                    if (!hasFireableAtCurrentPriority) {
                        currentPriority = buchiTransition.getPriority();
                    }
                    if (currentPriority != buchiTransition.getPriority() || !((KripkeBuchiLanguageModule)this.getModule()).buchiEvaluator.evaluate(buchiTransition.getGuard())) continue;
                    outFireables.add((Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>)new Pair((Object)new FiredTransition((Object)source.kripke, (Object)iConfiguration, kripkeFireable, kripkePayload), (Object)buchiTransition));
                    hasFireableAtCurrentPriority = true;
                }
            }
        }
    }

    private boolean[] getValuation(KripkeBuchiConfiguration source, Object kripkeFireable, Object kripkePayload, IConfiguration kripkeTarget) {
        return ((KripkeBuchiLanguageModule)this.getModule()).kripke.getAtomicPropositionEvaluator().getAtomicPropositionValuations((Object)source.kripke, kripkeFireable, kripkePayload, (Object)kripkeTarget);
    }

    boolean hasDeadlockAP() {
        return this.hasDeadlockAtomicProposition;
    }
}

