/*
 * Decompiled with CFR 0.152.
 */
package obp2.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.function.Predicate;
import obp2.core.IBuchiConfiguration;
import obp2.core.defaults.DefaultConfiguration;

public class ByteArrayConfiguration
extends DefaultConfiguration<ByteArrayConfiguration>
implements IBuchiConfiguration {
    public final byte[] state;
    Predicate<byte[]> isAccepting;

    public ByteArrayConfiguration(byte[] data) {
        this.state = data;
    }

    public ByteArrayConfiguration(byte[] data, Predicate<byte[]> isAccepting) {
        this.state = data;
        this.isAccepting = isAccepting;
    }

    @Override
    public ByteArrayConfiguration createCopy() {
        return new ByteArrayConfiguration(Arrays.copyOf(this.state, this.state.length));
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.state);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ByteArrayConfiguration) {
            byte[] otherState = ((ByteArrayConfiguration)obj).state;
            return Arrays.equals(this.state, otherState);
        }
        return false;
    }

    public String toString() {
        return "ByteArrayConfiguration [" + Arrays.toString(this.state) + "]";
    }

    public void writeOn(OutputStream os) throws IOException {
        os.write(this.state);
    }

    @Override
    public boolean isAccepting() {
        if (this.isAccepting == null) {
            return true;
        }
        return this.isAccepting.test(this.state);
    }
}

