/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.model.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.declarations.Field;
import org.cte.ABCD.model.types.CompositeType;

public abstract class FieldBasedType
extends CompositeType {
    private final List<Field> fieldsList = new ArrayList<Field>();

    public List<Field> getFieldsList() {
        return Collections.unmodifiableList(this.fieldsList);
    }

    public int getFieldsCount() {
        return this.fieldsList.size();
    }

    public Field getFields(int index) {
        if (index < 0 || index >= this.getFieldsCount()) {
            return null;
        }
        return this.fieldsList.get(index);
    }

    public void addFields(Field newValue) {
        this.addFields(this.getFieldsCount(), newValue);
    }

    public void addFields(int index, Field newValue) {
        this.fieldsList.add(index, newValue);
    }

    public Field setFields(int index, Field newValue) {
        return this.fieldsList.set(index, newValue);
    }

    public void addAllFields(Collection<Field> toAddList) {
        for (Field newValue : toAddList) {
            this.addFields(this.getFieldsCount(), newValue);
        }
    }

    public void removeFields(Field value) {
        int index = this.fieldsList.indexOf(value);
        if (index >= 0) {
            this.removeFields(index);
        }
    }

    public void removeFields(int index) {
        this.fieldsList.remove(index);
    }

    public void addFieldsAndOpposite(Field newValue) {
        this.addFields(newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
    }

    public void addAllFieldsAndOpposite(Collection<Field> toAddList) {
        for (Field newValue : toAddList) {
            this.addFieldsAndOpposite(this.getFieldsCount(), newValue);
        }
    }

    public void addFieldsAndOpposite(int index, Field newValue) {
        this.addFields(index, newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
    }

    public Field setFieldsAndOpposite(int index, Field newValue) {
        Field oldValue = this.fieldsList.set(index, newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
        return oldValue;
    }

    public void removeFieldsAndOpposite(Field removed) {
        this.removeFields(removed);
        if (removed != null) {
            removed.setParent(null);
        }
    }

    public void removeFieldsAndOpposite(int index) {
        Field removed = this.fieldsList.get(index);
        this.removeFields(index);
        if (removed != null) {
            removed.setParent(null);
        }
    }

    @Override
    public abstract void accept(ABCDVisitor var1);

    @Override
    public boolean equals(Object that) {
        return this.equalsCached(that, new IdentityHashMap<Object, Object>());
    }

    @Override
    public boolean equalsCached(Object that, IdentityHashMap<Object, Object> cache) {
        if (this == that) {
            cache.put(that, this);
            return true;
        }
        if (!(that instanceof FieldBasedType)) {
            return false;
        }
        Object o1 = cache.get(this);
        if (o1 != null) {
            return o1 == that;
        }
        Object o2 = cache.get(that);
        if (o2 != null) {
            return o2 == this;
        }
        if (!super.equalsFeatures((CompositeType)that, cache)) {
            return false;
        }
        return this.equalsFeatures((FieldBasedType)that, cache);
    }

    protected boolean equalsFeatures(FieldBasedType that, IdentityHashMap<Object, Object> cache) {
        int l1size = 0;
        int l2size = 0;
        l1size = this.fieldsList.size();
        if (l1size != (l2size = that.fieldsList.size())) {
            return false;
        }
        for (int i = 0; i < l1size; ++i) {
            if (this.fieldsList.get(i).equalsCached(that.fieldsList.get(i), cache)) continue;
            return false;
        }
        return true;
    }
}

