/*
 * Decompiled with CFR 0.152.
 */
package obp.predicate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.cdl.ProcessId;
import obp.predicate.AtomicAccess;
import obp.predicate.PredicateVisitor;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class SystemAccess
implements BoostObject {
    private ProcessId pid;
    private final List<AtomicAccess> accessList = new ArrayList<AtomicAccess>();

    public SystemAccess() {
    }

    protected SystemAccess(Boost boost) {
        boost.register((BoostObject)this);
        this.pid = (ProcessId)boost.readObject(ProcessId.class);
        for (AtomicAccess oneChild : BoostUtil.readObjectList((Boost)boost, AtomicAccess.class)) {
            this.accessList.add(oneChild);
        }
    }

    public ProcessId getPid() {
        return this.pid;
    }

    public void setPid(ProcessId newValue) {
        if (this.pid == null ? newValue != null : !this.pid.equals(newValue)) {
            this.pid = newValue;
        }
    }

    public List<AtomicAccess> getAccessList() {
        return Collections.unmodifiableList(this.accessList);
    }

    public int getAccessCount() {
        return this.accessList.size();
    }

    public AtomicAccess getAccess(int index) {
        if (index < 0 || index >= this.getAccessCount()) {
            return null;
        }
        return this.accessList.get(index);
    }

    public void addAccess(AtomicAccess newValue) {
        this.addAccess(this.getAccessCount(), newValue);
    }

    public void addAccess(int index, AtomicAccess newValue) {
        this.accessList.add(index, newValue);
    }

    public AtomicAccess setAccess(int index, AtomicAccess newValue) {
        return this.accessList.set(index, newValue);
    }

    public void addAllAccess(Collection<AtomicAccess> toAddList) {
        for (AtomicAccess newValue : toAddList) {
            this.addAccess(this.getAccessCount(), newValue);
        }
    }

    public void removeAccess(AtomicAccess value) {
        int index = this.accessList.indexOf(value);
        if (index >= 0) {
            this.removeAccess(index);
        }
    }

    public void removeAccess(int index) {
        this.accessList.remove(index);
    }

    public void writeToBoost(Boost boost) {
        boost.writeObject((BoostObject)this.pid);
        BoostUtil.writeObjectCollection((Boost)boost, this.accessList);
    }

    public void accept(PredicateVisitor visitor) {
        visitor.visitSystemAccess(this);
    }
}

