/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.compiler;

import java.io.File;
import java.io.PrintWriter;
import obp.fiacre.compiler.ProgramGenerator;
import obp.fiacre.model.Program;
import obp.fiacre.util.FiacreUtil;
import obp.tool.ToolController;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.ErrorHandler;

public class FiacreCompiler {
    private File fcrPath;

    public String getBaseName(File fiacreFile) {
        String name = fiacreFile.getName();
        int index = name.lastIndexOf(46);
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    public boolean deleteRecursive(File dir) {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                boolean result = true;
                for (File f : dir.listFiles()) {
                    result &= f.delete();
                }
                return result && dir.delete();
            }
            return dir.delete();
        }
        return true;
    }

    public File ensureDirectories(File fiacreFile, String dirExtension, String javaDirName) {
        File javaDirectory;
        String baseName = this.getBaseName(fiacreFile);
        File outputDirectory = new File(fiacreFile.getParentFile(), baseName + dirExtension);
        if (!outputDirectory.exists()) {
            outputDirectory.mkdir();
        }
        if ((javaDirectory = new File(outputDirectory, javaDirName)).exists()) {
            this.deleteRecursive(javaDirectory);
        }
        javaDirectory.mkdir();
        return javaDirectory;
    }

    public String compileFiacre(File fiacreFile, String dirExtension, String javaDirName, String javaBasePackage, PrintWriter out, PrintWriter err, ErrorHandler errorHandler) {
        File javaDirectory = this.ensureDirectories(fiacreFile, dirExtension, javaDirName);
        out.println("Compiling Fiacre file '" + fiacreFile.getPath() + "'.");
        Program program = null;
        try {
            program = FiacreUtil.loadProgram(fiacreFile);
        }
        catch (Exception e) {
            errorHandler.handleError(2, DiagnosticUtil.createMessage((Throwable)e) + "\n");
            throw new RuntimeException(e);
        }
        return this.compileFiacre(program, fiacreFile, javaBasePackage, javaDirectory, out, err, errorHandler);
    }

    public String compileFiacre(Program program, File fiacreFile, String javaBasePackage, File javaDirectory, PrintWriter out, PrintWriter err, ErrorHandler errorHandler) {
        ProgramGenerator generator = new ProgramGenerator(errorHandler, javaDirectory, javaBasePackage);
        String programName = generator.generate(fiacreFile, program);
        if (generator.usesFFI) {
            this.compileFFIBindings(javaDirectory, out, err, errorHandler);
        }
        return programName;
    }

    public String compileFiacre(File fiacreFile) {
        return this.compileFiacre(fiacreFile, ".obp", "java", null, new PrintWriter(System.out), new PrintWriter(System.err), ErrorHandler.simple);
    }

    private String getJavaByteCodeVersion() {
        return System.getProperty("java.version").substring(0, 3);
    }

    public File compileFFIBindings(File javaDirectory, PrintWriter out, PrintWriter err, ErrorHandler errorHandler) {
        String includeJniMDPath;
        String includeJniPath;
        File bindF;
        File binF = new File(javaDirectory, "../bin");
        if (!binF.exists()) {
            binF.mkdir();
        }
        if (!(bindF = new File(javaDirectory, "../bindings")).exists()) {
            bindF.mkdir();
        }
        String osName = System.getProperty("os.name");
        String[] options = new String[4];
        if (osName.indexOf("win") >= 0) {
            System.err.println("FFI calls on Windows are not supported yet!\n");
            System.out.println("FFI calls on Windows are not supported yet!\n");
            return null;
        }
        if (osName.startsWith("Mac")) {
            options[0] = "-dynamiclib";
            options[1] = ".dylib";
            includeJniPath = System.getProperty("java.home");
            if (includeJniPath.endsWith("jre")) {
                includeJniPath = includeJniPath + "/../include";
            }
            includeJniMDPath = includeJniPath + "/darwin";
            options[2] = "-I" + includeJniPath;
            options[3] = "-I" + includeJniMDPath;
            osName = "Darwin";
        }
        if (osName.startsWith("Linux")) {
            options[0] = "-shared";
            options[1] = ".so";
            includeJniPath = System.getProperty("java.home");
            if (includeJniPath.endsWith("jre")) {
                includeJniPath = includeJniPath + "/../include";
            }
            includeJniMDPath = includeJniPath + "/linux";
            options[2] = "-I" + includeJniPath;
            options[3] = "-I" + includeJniMDPath;
        }
        String linkPath = null;
        String userDir = System.getProperty("user.dir");
        linkPath = System.getProperty("sun.arch.data.model").equals("64") ? userDir + "/ffi/common/" + osName + "_x86_64" : userDir + "/ffi/common/" + osName + "_i686";
        String[] command = new String[]{"gcc", options[0], options[2], options[3], "-fPIC", "-std=c99", "-I" + userDir + "/ffi", new File(javaDirectory, "../bindings/ffi_bindings.c").getAbsolutePath(), "-g", "-o", new File(javaDirectory, "../bin/libprimitivesImplementation" + options[1]).getAbsolutePath(), "-L" + linkPath, "-lloader"};
        new ToolController(out, err){

            public void compileFFI(String[] comm) {
                this.scheduleClearResult();
                this.schedule(comm);
                this.schedulePopResult();
            }
        }.compileFFI(command);
        return null;
    }

    public File compileJava(File fiacreFile, String dirExtension, String javaDirName, String classDirName, PrintWriter out, PrintWriter err, ErrorHandler errorHandler) {
        String baseName = this.getBaseName(fiacreFile);
        File outputDirectory = new File(fiacreFile.getParentFile(), baseName + dirExtension);
        File javaDirectory = new File(outputDirectory, javaDirName);
        File classDirectory = new File(outputDirectory, classDirName);
        String[] command = new String[]{"-" + this.getJavaByteCodeVersion(), "-d", classDirectory.getPath(), "-warn:none", javaDirectory.getPath()};
        StringBuilder commandToPrint = new StringBuilder();
        commandToPrint.append("Exec: [ecj ");
        for (String arg : command) {
            if (commandToPrint.length() > 1) {
                commandToPrint.append(" ");
            }
            commandToPrint.append(arg);
        }
        commandToPrint.append("]");
        out.println(commandToPrint.toString());
        boolean succeeded = BatchCompiler.compile((String[])command, (PrintWriter)out, (PrintWriter)err, null);
        if (!succeeded) {
            String message = "Java Compilation failed.";
            errorHandler.handleError(2, message);
            throw new RuntimeException(message);
        }
        return classDirectory;
    }

    public File compileJava(File fiacreFile) {
        return this.compileJava(fiacreFile, ".obp", "java", "bin", new PrintWriter(System.out), new PrintWriter(System.err), ErrorHandler.simple);
    }

    public File compile(File fiacreFile) {
        this.compileFiacre(fiacreFile);
        return this.compileJava(fiacreFile);
    }

    private void usage() {
        System.out.println("Usage: FiacreCompiler <fiacre-file-path>");
        System.out.println();
        System.out.println("Other parameters:");
        System.out.println("\t[--help or -h]\t\t\tPrints this help and exit.");
    }

    public boolean readArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if ("--help".equals(args[i]) || "-h".equals(args[i])) {
                this.usage();
                return false;
            }
            if (this.fcrPath != null) continue;
            this.fcrPath = new File(args[i]);
        }
        if (this.fcrPath == null) {
            System.err.println("missing path to the fiacre file");
            this.usage();
            return false;
        }
        return true;
    }

    public void defaultCompile() {
        File result = this.compile(this.fcrPath);
        String programQualifiedName = ProgramGenerator.getProgramQualifiedName(null, this.getBaseName(this.fcrPath));
        System.out.println("Compiled fiacre file in: \n\t- " + result.getPath() + " [" + programQualifiedName + "]");
    }

    public static void main(String[] args) {
        FiacreCompiler main = new FiacreCompiler();
        try {
            if (main.readArguments(args)) {
                main.defaultCompile();
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }
}

