/*
 * Decompiled with CFR 0.152.
 */
package obp.cdl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.cdl.CdlVisitor;
import obp.cdl.Declaration;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class VariableDeclaration
extends Declaration
implements BoostObject {
    private final List<String> valueList = new ArrayList<String>();

    public VariableDeclaration() {
    }

    protected VariableDeclaration(Boost boost) {
        super(boost);
        for (String oneChild : BoostUtil.readStringArray((Boost)boost)) {
            this.valueList.add(oneChild);
        }
    }

    public List<String> getValueList() {
        return Collections.unmodifiableList(this.valueList);
    }

    public int getValueCount() {
        return this.valueList.size();
    }

    public String getValue(int index) {
        if (index < 0 || index >= this.getValueCount()) {
            return null;
        }
        return this.valueList.get(index);
    }

    public void addValue(String newValue) {
        this.addValue(this.getValueCount(), newValue);
    }

    public void addValue(int index, String newValue) {
        this.valueList.add(index, newValue);
    }

    public String setValue(int index, String newValue) {
        return this.valueList.set(index, newValue);
    }

    public void addAllValue(Collection<String> toAddList) {
        for (String newValue : toAddList) {
            this.addValue(this.getValueCount(), newValue);
        }
    }

    public void removeValue(String value) {
        int index = this.valueList.indexOf(value);
        if (index >= 0) {
            this.removeValue(index);
        }
    }

    public void removeValue(int index) {
        this.valueList.remove(index);
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        BoostUtil.writeStringCollection((Boost)boost, this.valueList);
    }

    @Override
    public void accept(CdlVisitor visitor) {
        visitor.visitVariableDeclaration(this);
    }
}

