/*
 * Decompiled with CFR 0.152.
 */
package obp.util;

import obp.cdl.EventReference;
import obp.obs.Observer;
import obp.obs.Reset;
import obp.obs.State;
import obp.obs.Transition;
import obp.obs.Type;
import obp.obs.When;
import obp.predicate.AllPredicate;
import obp.predicate.ComparisonOperator;
import obp.util.PredicateUtil;

public class ObsUtil {
    public static String toDot(Observer obs) {
        StringBuilder dot = new StringBuilder();
        dot.append("digraph ");
        if (obs.getName() != null) {
            dot.append(obs.getName());
        } else {
            dot.append("Context");
        }
        dot.append(" { \n\trankdir=LR;\n");
        dot.append("\t");
        dot.append(obs.getStartState().getName());
        dot.append(" [peripheries=2];\n");
        for (State state : obs.getStateList()) {
            switch (state.getType()) {
                case Reject: {
                    dot.append("\t");
                    dot.append(state.getName());
                    dot.append(" [color=red];\n");
                    break;
                }
                case Success: {
                    dot.append("\t");
                    dot.append(state.getName());
                    dot.append(" [color=green];\n");
                    break;
                }
                case Cut: {
                    dot.append("\t");
                    dot.append(state.getName());
                    dot.append(" [color=gray];\n");
                    break;
                }
            }
        }
        for (int i = 0; i < obs.getTransitionCount(); ++i) {
            Transition transition = obs.getTransition(i);
            dot.append("\t");
            dot.append(transition.getSource().getName());
            dot.append(" -> ");
            dot.append(transition.getTarget().getName());
            dot.append(" [taillabel=\"(");
            dot.append(i + 1);
            dot.append(")\" label=\"");
            if (transition.getWhen() != null) {
                dot.append(ObsUtil.toString(transition.getWhen()));
            }
            dot.append("/");
            if (transition.getGuard() != null && !(transition.getGuard() instanceof AllPredicate)) {
                dot.append(PredicateUtil.printPredicate(transition.getGuard()));
            }
            dot.append("/");
            boolean first = true;
            for (EventReference eR : transition.getEventsList()) {
                if (first) {
                    first = false;
                } else {
                    dot.append(" | ");
                }
                dot.append(eR.getName());
            }
            dot.append("/");
            if (transition.getReset() != null) {
                dot.append(ObsUtil.toString(transition.getReset()));
            }
            dot.append("\"];\n");
        }
        dot.append("}");
        return dot.toString();
    }

    public static String toString(When when) {
        StringBuilder string = new StringBuilder();
        string.append(when.getClock());
        switch (when.getType()) {
            case GREATER: {
                string.append(" > ");
                break;
            }
            case GREATER_OR_EQUAL: {
                string.append(" >= ");
                break;
            }
            case LESSER: {
                string.append(" < ");
                break;
            }
            case LESSER_OR_EQUAL: {
                string.append(" <= ");
            }
        }
        string.append(when.getValue());
        return string.toString();
    }

    public static String toString(Reset reset) {
        StringBuilder string = new StringBuilder();
        string.append(reset.getClock());
        string.append(" := ");
        string.append(reset.getValue());
        return string.toString();
    }

    public static State createState(String name, Type type) {
        State state = new State();
        state.setName(name);
        state.setType(type);
        return state;
    }

    public static Transition createTransition(State source, State target, When guard, EventReference reference, Reset reset) {
        Transition transition = new Transition();
        transition.setSourceAndOpposite(source);
        transition.setTargetAndOpposite(target);
        transition.setWhen(guard);
        if (reference != null) {
            transition.addEvents(reference);
        }
        transition.setReset(reset);
        return transition;
    }

    public static When createWhen(String clock, ComparisonOperator type, int value) {
        When when = new When();
        when.setClock(clock);
        when.setType(type);
        when.setValue(value);
        return when;
    }

    public static Reset createReset(String clock, int value) {
        Reset reset = new Reset();
        reset.setClock(clock);
        reset.setValue(value);
        return reset;
    }
}

