/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.model.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.declarations.ArgumentMap;
import org.cte.ABCD.model.declarations.ElementWithArgumentMap;
import org.cte.ABCD.model.declarations.FunctionDecl;
import org.cte.ABCD.model.kernel.Expression;

public class FunctionCall
implements Expression,
ElementWithArgumentMap {
    private String functionName;
    private FunctionDecl functionDeclaration;
    private final List<ArgumentMap> argumentsList = new ArrayList<ArgumentMap>();

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String newValue) {
        if (this.functionName == null ? newValue != null : !this.functionName.equals(newValue)) {
            this.functionName = newValue;
        }
    }

    public FunctionDecl getFunctionDeclaration() {
        return this.functionDeclaration;
    }

    public void setFunctionDeclaration(FunctionDecl newValue) {
        if (this.functionDeclaration == null ? newValue != null : !this.functionDeclaration.equals(newValue)) {
            this.functionDeclaration = newValue;
        }
    }

    @Override
    public List<ArgumentMap> getArgumentsList() {
        return Collections.unmodifiableList(this.argumentsList);
    }

    @Override
    public int getArgumentsCount() {
        return this.argumentsList.size();
    }

    @Override
    public ArgumentMap getArguments(int index) {
        if (index < 0 || index >= this.getArgumentsCount()) {
            return null;
        }
        return this.argumentsList.get(index);
    }

    @Override
    public void addArguments(ArgumentMap newValue) {
        this.addArguments(this.getArgumentsCount(), newValue);
    }

    @Override
    public void addArguments(int index, ArgumentMap newValue) {
        this.argumentsList.add(index, newValue);
    }

    @Override
    public ArgumentMap setArguments(int index, ArgumentMap newValue) {
        return this.argumentsList.set(index, newValue);
    }

    @Override
    public void addAllArguments(Collection<ArgumentMap> toAddList) {
        for (ArgumentMap newValue : toAddList) {
            this.addArguments(this.getArgumentsCount(), newValue);
        }
    }

    @Override
    public void removeArguments(ArgumentMap value) {
        int index = this.argumentsList.indexOf(value);
        if (index >= 0) {
            this.removeArguments(index);
        }
    }

    @Override
    public void removeArguments(int index) {
        this.argumentsList.remove(index);
    }

    @Override
    public void addArgumentsAndOpposite(ArgumentMap newValue) {
        this.addArguments(newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public void addAllArgumentsAndOpposite(Collection<ArgumentMap> toAddList) {
        for (ArgumentMap newValue : toAddList) {
            this.addArgumentsAndOpposite(this.getArgumentsCount(), newValue);
        }
    }

    @Override
    public void addArgumentsAndOpposite(int index, ArgumentMap newValue) {
        this.addArguments(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public ArgumentMap setArgumentsAndOpposite(int index, ArgumentMap newValue) {
        ArgumentMap oldValue = this.argumentsList.set(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
        return oldValue;
    }

    @Override
    public void removeArgumentsAndOpposite(ArgumentMap removed) {
        this.removeArguments(removed);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public void removeArgumentsAndOpposite(int index) {
        ArgumentMap removed = this.argumentsList.get(index);
        this.removeArguments(index);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public void accept(ABCDVisitor visitor) {
        visitor.visitFunctionCall(this);
    }

    public boolean equals(Object that) {
        return this.equalsCached(that, new IdentityHashMap<Object, Object>());
    }

    @Override
    public boolean equalsCached(Object that, IdentityHashMap<Object, Object> cache) {
        if (this == that) {
            cache.put(that, this);
            return true;
        }
        if (!(that instanceof FunctionCall)) {
            return false;
        }
        Object o1 = cache.get(this);
        if (o1 != null) {
            return o1 == that;
        }
        Object o2 = cache.get(that);
        if (o2 != null) {
            return o2 == this;
        }
        return this.equalsFeatures((FunctionCall)that, cache);
    }

    protected boolean equalsFeatures(FunctionCall that, IdentityHashMap<Object, Object> cache) {
        int l1size = 0;
        int l2size = 0;
        if (!this.functionName.equals(that.functionName)) {
            return false;
        }
        if (this.argumentsList != null) {
            if (that.argumentsList == null) {
                return false;
            }
            l1size = this.argumentsList.size();
            if (l1size != (l2size = that.argumentsList.size())) {
                return false;
            }
            for (int i = 0; i < l1size; ++i) {
                if (this.argumentsList.get(i).equalsCached(that.argumentsList.get(i), cache)) continue;
                return false;
            }
        }
        return true;
    }
}

