/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.compiler;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.ABCDWalker;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.FunctionDecl;
import org.cte.ABCD.model.declarations.NamedDeclaration;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.expressions.FunctionCall;

public class FunctionResolver {
    private ABCDSystem system;
    private Map<String, FunctionDecl> functionHash;

    public FunctionResolver(ABCDSystem system) {
        this.system = system;
        this.functionHash = new LinkedHashMap<String, FunctionDecl>();
    }

    public void resolveAndBind() {
        for (FunctionDecl pd : this.system.getFunctionsList()) {
            if (this.functionHash.put(pd.getName(), pd) == null) continue;
            System.err.println("Multiple definition of function '" + pd.getName() + "' (only the last one is used)");
        }
        this.resolveFunctions();
    }

    private void bindParameters(FunctionDecl fD, FunctionCall call) {
        if (fD.getParametersCount() != call.getArgumentsCount()) {
            System.err.println("The function " + fD.getName() + " expects " + fD.getParametersCount() + " parameters but its instantiation provides " + call.getArgumentsCount());
        } else if (fD.getParametersCount() > 0) {
            boolean hasNamedAssociations = call.getArguments(0).getFormalName() != null;
            for (int i = 0; i < fD.getParametersCount(); ++i) {
                String formalName = call.getArguments(i).getFormalName();
                if (formalName != null) {
                    if (!hasNamedAssociations) {
                        System.err.println("Mixing named and unamed argument mappings for function call is not supported");
                        break;
                    }
                    ParameterDecl param = this.getNamedDeclaration(fD.getParametersList(), formalName, ParameterDecl.class);
                    if (param == null) {
                        System.err.println("The function '" + fD.getName() + "' does not have a parameter named '" + formalName + "'");
                        break;
                    }
                    call.getArguments(i).setFormal(param);
                    continue;
                }
                if (hasNamedAssociations) {
                    System.err.println("Mixing named and unamed argument mappings for function call is not supported");
                    break;
                }
                call.getArguments(i).setFormal(fD.getParameters(i));
            }
        }
    }

    private <T extends NamedDeclaration> T getNamedDeclaration(List<T> elements, String name, Class<T> type) {
        for (NamedDeclaration p : elements) {
            if (!p.getName().equals(name)) continue;
            return (T)((NamedDeclaration)type.cast(p));
        }
        return null;
    }

    private void resolveFunctions() {
        final ArrayList calls = new ArrayList();
        ABCDWalker walker = new ABCDWalker(new ABCDVisitor.Stub(){

            @Override
            public void visitFunctionCall(FunctionCall node) {
                calls.add(node);
            }
        });
        this.system.accept(walker);
        for (FunctionCall call : calls) {
            if (call.getFunctionDeclaration() != null) continue;
            FunctionDecl fD = this.functionHash.get(call.getFunctionName());
            if (fD == null) {
                System.err.println("Cannot find function '" + call.getFunctionName() + "'");
                continue;
            }
            this.bindParameters(fD, call);
            call.setFunctionDeclaration(fD);
        }
    }
}

