/*
 * Decompiled with CFR 0.152.
 */
package obp.states;

import obp.states.Element;
import obp.states.Match;
import obp.states.PID;
import obp.states.State;
import obp.states.StatesVisitor;
import obp.states.Variable;

public class Observer
extends Element {
    protected Variable[] variableList;
    protected PID pid;
    protected Match[] matchList;
    protected String currentState;
    protected State parent;

    protected Observer() {
        this(null, null, null, null);
    }

    public Observer(PID pid, String currentState, Variable[] variableList, Match[] messageList) {
        this.pid = pid;
        this.currentState = currentState;
        this.variableList = variableList;
        this.matchList = messageList;
    }

    public Variable[] getVariableList() {
        return this.variableList;
    }

    public int getVariableCount() {
        return this.variableList.length;
    }

    public PID getPid() {
        return this.pid;
    }

    public Match[] getMatchList() {
        return this.matchList;
    }

    public int getMatchCount() {
        return this.matchList.length;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public State getParent() {
        return this.parent;
    }

    @Override
    public void accept(StatesVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currentState == null ? 0 : this.currentState.hashCode());
        result = 31 * result + (this.matchList == null ? 0 : this.matchList.hashCode());
        result = 31 * result + (this.pid == null ? 0 : this.pid.hashCode());
        result = 31 * result + (this.variableList == null ? 0 : this.variableList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Observer other = (Observer)obj;
        if (this.currentState == null ? other.currentState != null : !this.currentState.equals(other.currentState)) {
            return false;
        }
        if (this.matchList == null ? other.matchList != null : !this.matchList.equals(other.matchList)) {
            return false;
        }
        if (this.pid == null ? other.pid != null : !this.pid.equals(other.pid)) {
            return false;
        }
        return !(this.variableList == null ? other.variableList != null : !this.variableList.equals(other.variableList));
    }
}

