/*
 * Decompiled with CFR 0.152.
 */
package obp.partition;

import java.util.Stack;
import obp.cc.ConcreteContext;
import obp.partition.ConcreteContextPartitioner;
import obp.partition.SimplePartitioner;

public class AutoSplitPartitioner
extends ConcreteContextPartitioner {
    private final Stack<ConcreteContextPartitioner> partitionerStack = new Stack();
    private final int splitStep;
    private ConcreteContext currentContext = null;
    private int count = 0;

    public AutoSplitPartitioner(ConcreteContext cc, int initialSplit, int splitStep) {
        this.partitionerStack.push(new SimplePartitioner(cc, initialSplit));
        this.splitStep = splitStep;
    }

    public int getSplitDepth() {
        return this.splitStep;
    }

    @Override
    public boolean hasNext() {
        return !this.partitionerStack.isEmpty();
    }

    @Override
    public ConcreteContext next() {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("No more partition available.");
        }
        ConcreteContextPartitioner partitioner = this.partitionerStack.peek();
        this.currentContext = (ConcreteContext)partitioner.next();
        while (this.partitionerStack.size() > 0 && !this.partitionerStack.peek().hasNext()) {
            this.partitionerStack.pop();
        }
        ++this.count;
        return this.currentContext;
    }

    public void explorationFailed() {
        this.partitionerStack.push(new SimplePartitioner(this.currentContext, this.splitStep));
    }

    @Override
    public int getCount() {
        return this.count;
    }
}

