/*
 * Decompiled with CFR 0.152.
 */
package obp.interpreter;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import obp.interpreter.IBehavior;
import obp.interpreter.IProgram;
import obp.interpreter.ITransition;
import org.xid.basics.sexp.S;
import org.xid.basics.sexp.SExp;
import org.xid.basics.sexp.SVariable;
import org.xid.basics.sexp.VariableResolver;
import org.xid.basics.sexp.model.Referencer;
import org.xid.basics.sexp.model.SExpToModel;

public class SExpToInterpreter {
    private final SExpToModel context;
    private final VariableResolver resolver;

    public SExpToInterpreter(Referencer referencer) {
        this(referencer, (VariableResolver)new VariableResolver.Mapped());
    }

    public SExpToInterpreter(Referencer referencer, VariableResolver resolver) {
        this.context = new SExpToModel(referencer, resolver);
        this.resolver = resolver;
    }

    private IProgram createIProgram(SExp sexp) throws IOException {
        String type;
        SExp currentSexp;
        int current;
        IProgram result = new IProgram();
        int count = sexp.getChildCount();
        for (current = 1; current < count; ++current) {
            Collection valueList;
            currentSexp = sexp.getChild(current);
            type = currentSexp.getConstructor();
            if ("name".equals(type)) {
                result.setName(S.sexpToString((SExp)currentSexp));
                continue;
            }
            if ("init".equals(type)) {
                result.setInit(S.sexpToString((SExp)currentSexp));
                continue;
            }
            if ("eventSet".equals(type)) {
                valueList = S.sexpToStringCollection((SExp)currentSexp);
                for (String value : valueList) {
                    result.addEvent(value);
                }
                continue;
            }
            if (!"informalSet".equals(type)) break;
            valueList = S.sexpToStringCollection((SExp)currentSexp);
            for (String value : valueList) {
                result.addInformal(value);
            }
        }
        this.context.push((Object)result);
        while (current < count) {
            currentSexp = sexp.getChild(current);
            type = currentSexp.getConstructor();
            if ("behaviorSet".equals(type)) {
                for (int i = 1; i < currentSexp.getChildCount(); ++i) {
                    IBehavior child = this.create(IBehavior.class, currentSexp.getChild(i));
                    result.addBehavior(child);
                }
            } else {
                StringBuilder message = new StringBuilder();
                if (type == null) {
                    message.append("Unknown attribute format '");
                    message.append(currentSexp);
                    message.append("' for type 'IProgram'.");
                } else {
                    message.append("Unknown attribute '");
                    message.append(type);
                    message.append("' for type 'IProgram'.");
                }
                throw new IOException(message.toString());
            }
            ++current;
        }
        this.context.pop((Object)result);
        return result;
    }

    private IBehavior createIBehavior(SExp sexp) throws IOException {
        String type;
        SExp currentSexp;
        int current;
        IBehavior result = new IBehavior();
        int count = sexp.getChildCount();
        for (current = 1; current < count; ++current) {
            Collection valueList;
            currentSexp = sexp.getChild(current);
            type = currentSexp.getConstructor();
            if ("name".equals(type)) {
                result.setName(S.sexpToString((SExp)currentSexp));
                continue;
            }
            if ("valueSet".equals(type)) {
                valueList = S.sexpToStringCollection((SExp)currentSexp);
                for (String value : valueList) {
                    result.addValue(value);
                }
                continue;
            }
            if ("initializerSet".equals(type)) {
                valueList = S.sexpToStringCollection((SExp)currentSexp);
                for (String value : valueList) {
                    result.addInitializer(value);
                }
                continue;
            }
            if (!"triggerSet".equals(type)) break;
            valueList = S.sexpToStringCollection((SExp)currentSexp);
            for (String value : valueList) {
                result.addTrigger(value);
            }
        }
        this.context.push((Object)result);
        while (current < count) {
            currentSexp = sexp.getChild(current);
            type = currentSexp.getConstructor();
            if ("transitionSet".equals(type)) {
                for (int i = 1; i < currentSexp.getChildCount(); ++i) {
                    ITransition child = this.create(ITransition.class, currentSexp.getChild(i));
                    result.addTransition(child);
                }
            } else {
                StringBuilder message = new StringBuilder();
                if (type == null) {
                    message.append("Unknown attribute format '");
                    message.append(currentSexp);
                    message.append("' for type 'IBehavior'.");
                } else {
                    message.append("Unknown attribute '");
                    message.append(type);
                    message.append("' for type 'IBehavior'.");
                }
                throw new IOException(message.toString());
            }
            ++current;
        }
        this.context.pop((Object)result);
        return result;
    }

    private ITransition createITransition(SExp sexp) throws IOException {
        ITransition result = new ITransition();
        int count = sexp.getChildCount();
        for (int current = 1; current < count; ++current) {
            SExp currentSexp = sexp.getChild(current);
            String type = currentSexp.getConstructor();
            if ("on".equals(type)) {
                result.setOn(S.sexpToString((SExp)currentSexp));
                continue;
            }
            if ("guard".equals(type)) {
                result.setGuard(S.sexpToString((SExp)currentSexp));
                continue;
            }
            if ("action".equals(type)) {
                result.setAction(S.sexpToString((SExp)currentSexp));
                continue;
            }
            StringBuilder message = new StringBuilder();
            if (type == null) {
                message.append("Unknown attribute format '");
                message.append(currentSexp);
                message.append("' for type 'ITransition'.");
            } else {
                message.append("Unknown attribute '");
                message.append(type);
                message.append("' for type 'ITransition'.");
            }
            throw new IOException(message.toString());
        }
        this.context.push((Object)result);
        this.context.pop((Object)result);
        return result;
    }

    public <T> T to(Class<T> klass, SExp sexp) throws IOException {
        T result = this.create(klass, sexp);
        Set<String> unresolvedReferences = this.unresolvedReferences();
        if (!unresolvedReferences.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Unresolved reference(s): ");
            int length = message.length();
            for (String reference : unresolvedReferences) {
                if (message.length() > length) {
                    message.append(", ");
                }
                message.append(reference);
            }
            message.append(".");
            throw new IOException(message.toString());
        }
        return result;
    }

    public <T> T create(Class<T> klass, SExp sexp) throws IOException {
        if (sexp.isVariable()) {
            return (T)this.resolver.resolve(((SVariable)sexp).getName(), klass);
        }
        String type = sexp.getConstructor();
        Object result = null;
        if ("iProgram".equals(type)) {
            result = this.createIProgram(sexp);
        } else if ("iBehavior".equals(type)) {
            result = this.createIBehavior(sexp);
        } else if ("iTransition".equals(type)) {
            result = this.createITransition(sexp);
        } else {
            StringBuilder message = new StringBuilder();
            if (type == null) {
                message.append("Can't create a '");
                message.append(klass.getSimpleName());
                message.append("' instance from '");
                message.append(sexp);
                message.append("'.");
            } else {
                message.append("Unknown type '");
                message.append(type);
                message.append("'.");
            }
            throw new IOException(message.toString());
        }
        return result == null ? null : (T)klass.cast(result);
    }

    public Set<String> unresolvedReferences() {
        return this.context.unresolvedReferences();
    }
}

